package ru.yandex.chemodan.app.dataapi.worker.tasks;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.dataapi.api.datasource.DataSourceType;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.core.datasources.migration.DsMigrationManager;
import ru.yandex.chemodan.app.dataapi.core.datasources.migration.DsMigrationSpec;
import ru.yandex.chemodan.app.dataapi.worker.DataApiTaskQueueName;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DataSourceMigrationTask extends OnetimeTaskSupport<DsMigrationSpec> {
    private DsMigrationManager migrationManager;

    public DataSourceMigrationTask(DatabaseRef dbRef, DataSourceType srcType, DataSourceType tgtType) {
        super(DsMigrationSpec.cons(dbRef, srcType, tgtType));
    }

    public DataSourceMigrationTask(DsMigrationSpec params) {
        super(params);
    }

    public DataSourceMigrationTask(DsMigrationManager migrationManager) {
        super(DsMigrationSpec.class);
        this.migrationManager = migrationManager;
    }

    @Override
    protected void execute(DsMigrationSpec params, ExecutionContext context) throws Exception {
        migrationManager.migrate(params);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardDays(10);
    }

    @Override
    public TaskQueueName queueName() {
        return DataApiTaskQueueName.DATAAPI_REGULAR;
    }
}
