package ru.yandex.chemodan.notifier;

import lombok.AllArgsConstructor;
import lombok.RequiredArgsConstructor;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.web.DataApiActionBase;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author bursy
 */
@Path(value = "{prefix:|api/}get-unread-notifications-count", methods = {HttpMethod.GET})
@Path(value = "/platform/personality/profile/notifications/unread-count", methods = {HttpMethod.GET})
@WithMasterSlavePolicy(MasterSlavePolicy.R_ANY)
@RequiredArgsConstructor
public class GetUnreadNotificationsCountAction extends DataApiActionBase {
    @RequestParam
    private Option<String> service;

    private final NotifierUnreadCountProvider unreadCountProvider;

    @Override
    public Object execute() {
        int count = service.isPresent()
                ? unreadCountProvider.getForService(user, service.get())
                : unreadCountProvider.getForEnabledServices(user);

        return new NotificationsCountPojo(count);
    }

    @ActionResultPojo
    @AllArgsConstructor
    @BenderBindAllFields
    private static final class NotificationsCountPojo {
        public final long count;
    }
}
