package ru.yandex.chemodan.notifier;

import ru.yandex.chemodan.app.dataapi.api.data.record.RecordId;
import ru.yandex.chemodan.app.dataapi.api.data.record.SimpleRecordId;
import ru.yandex.chemodan.app.dataapi.api.db.ref.AppDatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.UserDatabaseSpec;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiPublicUserId;

/**
 * @author dbrylev
 */
public class NotifierDatabasing {
    public static final String APP_NAME = "notifier";

    public static final DatabaseRef SERVICES_DB = new AppDatabaseRef(APP_NAME, "notification_services");
    public static final DatabaseRef SERVICES_YT_DB = new AppDatabaseRef(APP_NAME, "notification_services_yateam");

    public static final UserDatabaseSpec SERVICES_DB_SPEC =
            new UserDatabaseSpec(new DataApiPublicUserId(), SERVICES_DB);
    public static final UserDatabaseSpec SERVICES_YT_DB_SPEC =
            new UserDatabaseSpec(new DataApiPublicUserId(), SERVICES_YT_DB);

    public static final String SERVICES_COLLECTION = "services";


    public static final DatabaseRef NOTIFICATIONS_DB = new AppDatabaseRef(APP_NAME, "notifications_disk");

    public static final String META_COLLECTION = "meta";

    public static RecordId metaRecordIdFor(String service) {
        return new SimpleRecordId(META_COLLECTION, service.equals("disk") ? "id" : service);
    }

    public static final String UNREAD_COUNT_FIELD = "unviewed_count";
}
