package ru.yandex.chemodan.notifier;

import javax.annotation.PostConstruct;

import lombok.RequiredArgsConstructor;
import org.joda.time.Duration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.api.data.filter.RecordsFilter;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.db.ref.UserDatabaseSpec;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.misc.worker.spring.DelayingWorkerServiceBeanSupport;

/**
 * @author bursy
 */
@RequiredArgsConstructor
public class NotifierEnabledServicesProvider extends DelayingWorkerServiceBeanSupport {

    private final DataApiManager dataApiManager;

    private ListF<String> enabledServiceNames = Cf.list();
    private ListF<String> enabledYaTeamServiceNames = Cf.list();

    @PostConstruct
    public void init() {
        refreshEnabledServices();
    }

    public ListF<String> getEnabledServiceNames() {
        return enabledServiceNames;
    }

    public ListF<String> getEnabledYaTeamServiceNames() {
        return enabledYaTeamServiceNames;
    }

    private void refreshEnabledServices() {
        enabledServiceNames = getEnabledServices(NotifierDatabasing.SERVICES_DB_SPEC);
        enabledYaTeamServiceNames = getEnabledServices(NotifierDatabasing.SERVICES_YT_DB_SPEC);
    }

    private ListF<String> getEnabledServices(UserDatabaseSpec db) {
        RecordsFilter filter = RecordsFilter.DEFAULT.withCollectionId(NotifierDatabasing.SERVICES_COLLECTION);

        return dataApiManager.getRecords(db, filter).map(DataRecord::getRecordId);
    }

    @Override
    protected void execute() {
        refreshEnabledServices();
    }

    protected Duration defaultDelay() {
        return Duration.standardMinutes(5);
    }
}
