package ru.yandex.chemodan.notifier;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.dataapi.core.DatabasesContextConfiguration;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;

/**
 * @author dbrylev
 */
@Configuration
@Import(DatabasesContextConfiguration.class)
public class NotifierUnreadCountProviderContextConfiguration {

    @Bean
    public NotifierEnabledServicesProvider notifierEnabledServicesProvider(DataApiManager dataApiManager) {
        return new NotifierEnabledServicesProvider(dataApiManager);
    }

    @Bean
    public NotifierUnreadCountProvider notifierUnreadCountProvider(
            DataApiManager dataApiManager, NotifierEnabledServicesProvider enabledServicesProvider)
    {
        return new NotifierUnreadCountProvider(dataApiManager, enabledServicesProvider);
    }
}
