JAVA_PROGRAM(disk-dataapi)

INCLUDE(${ARCADIA_ROOT}/disk/support/common_header.inc)

OWNER(g:disk)

PEERDIR(
    disk/support/common
    disk/support/bazinga
    disk/support/logbroker
    disk/support/dataapi
    disk/support/ydb-common

    devtools/jtest

    contrib/java/com/google/guava/guava/25.1-android

    iceberg/misc-geo

    iceberg/inside-client-utils
    iceberg/inside-elliptics
    iceberg/inside-geocoder
    iceberg/inside-geosearch
    iceberg/misc-async-http-client-2

    contrib/java/org/jparsec/jparsec/3.0
    contrib/java/org/codehaus/jparsec/2.2.1

    contrib/java/com/github/fge/json-schema-core/1.2.5
    contrib/java/com/github/fge/json-schema-validator/2.2.6

    contrib/java/net/spy/spymemcached/2.11.4
    contrib/java/org/mockito/mockito-core/2.23.4
)

INCLUDE(${ARCADIA_ROOT}/disk/support/exclude.inc)
INCLUDE(${ARCADIA_ROOT}/disk/support/lombok.inc)

EXCLUDE(
    # this artifact is outdated
    contrib/java/log4j/log4j

    # this dependencies break compilation (from contrib/java/org/codehaus/jparsec/2.2.1)
    contrib/java/org/easymock/easymock/2.4
    contrib/java/junit/junit/4.8.1

    contrib/java/javax/mail/mailapi/1.4.3
)

JAVA_SRCS(SRCDIR src/main/java **/*)
JAVA_SRCS(SRCDIR src/test/resources **/*)

LINT(base)
END()

RECURSE(
    ut
    ut_ydb
    src/main/java/ru/yandex/chemodan/app/dataapi/worker/importer/diff
)
