#include <library/cpp/neh/neh.h>
#include <library/cpp/neh/rpc.h>

#include <util/stream/input.h>

using namespace NNeh;

class TMyService {
public:
    inline void ServeRequest(const IRequestRef& req) {
        TStringBuf data = req->Data();
//        TString data = "pong";
        TData res(data.begin(), data.begin() + data.size());
        req->SendReply(res);
    }
};

int main() {
    TMyService srv;
    IServicesRef ssr = CreateLoop();

    ssr->Add("http://*:4242/my_service", srv);
    try {
        const int threadPoolSize = 2;

        ssr->ForkLoop(threadPoolSize);
    } catch (...) {
        Cerr << "can't run services: " << CurrentExceptionMessage() << Endl;
        return 1;
    }
    Cout << "Service started (for exit close stdin: Ctrl-D)\n";
    Cout.Flush();
    try {
        TString line = Cin.ReadLine();
    } catch (...) {
    }
    return 0;
}
