package ru.yandex.chemodan.app.dataapi.worker;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.dataapi.DataApiCoreContextConfiguration;
import ru.yandex.chemodan.app.dataapi.api.deltas.cleaning.DeltasCleaningContextConfiguration;
import ru.yandex.chemodan.app.dataapi.api.deltas.cleaning.DeltasCleaningTask;
import ru.yandex.chemodan.app.dataapi.api.deltas.cleaning.UploadShardRevisionsToYtTask;
import ru.yandex.chemodan.app.dataapi.web.admin.DataApiCoreAdminContextConfiguration;
import ru.yandex.chemodan.app.dataapi.worker.importer.ImportDataChunkTask;
import ru.yandex.chemodan.bazinga.BazingaWorkerTaskQueues;
import ru.yandex.chemodan.bazinga.ChemodanBazingaWorkerContextConfiguration;
import ru.yandex.commune.bazinga.pg.worker.PgBazingaWorkerConfiguration;
import ru.yandex.commune.bazinga.scheduler.TaskQueue;
import ru.yandex.misc.ip.IpPort;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        ChemodanBazingaWorkerContextConfiguration.class,
        DataApiCoreContextConfiguration.class,
        DataApiCoreAdminContextConfiguration.class,
        DataApiTasksContextConfiguration.class,
        DeltasCleaningContextConfiguration.class,
})
public class DataApiWorkerContextConfiguration {

    @Value("${monica.master.port}")
    private IpPort monicaPort;

    @Bean
    @Qualifier("monicaMasterPort")
    public IpPort monicaMasterPort() {
        return monicaPort;
    }

    @Bean
    public PgBazingaWorkerConfiguration pgBazingaWorkerConfiguration() {
        return new PgBazingaWorkerConfiguration(Cf.list(DataApiTaskQueueName.DATAAPI_CRON));
    }

    @Bean
    public BazingaWorkerTaskQueues taskQueues(
            @Value("${dataapi.import.data.from.yt.onetime.tasks.count}")
            int importDataFromYtCount,
            @Value("${dataapi.import.data.from.yt.onetime.tasks.queue}")
            int importDataFromYtQueue,
            @Value("${dataapi-worker.deltas-cleaning.tasks.count}")
            int deltasCleaningCount,
            @Value("${dataapi-worker.deltas-cleaning.tasks.queue}")
            int deltasCleaningQueue,
            @Value("${dataapi-worker.upload-revisions.tasks.count}")
            int uploadRevisionsCount,
            @Value("${dataapi-worker.upload-revisions.tasks.queue}")
            int uploadRevisionsQueue)
    {
        return new BazingaWorkerTaskQueues(
                DataApiTaskQueueName.DATAAPI_CRON,
                DataApiTaskQueueName.DATAAPI_REGULAR,
                DataApiTaskQueueName.DATAAPI_CPU_INTENSIVE,
                Cf.list(
                        new TaskQueue(ImportDataChunkTask.IMPORT_DATA_QUEUE, importDataFromYtCount, importDataFromYtQueue),
                        new TaskQueue(DeltasCleaningTask.DELETE_DELTAS_QUEUE, deltasCleaningCount, deltasCleaningQueue),
                        new TaskQueue(UploadShardRevisionsToYtTask.UPLOAD_REVISIONS_QUEUE, uploadRevisionsCount, uploadRevisionsQueue)
                ));
    }
}
