package ru.yandex.chemodan.app.dataapi.worker;

import org.springframework.context.ConfigurableApplicationContext;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.log.DataapiLog4jHelper;
import ru.yandex.chemodan.boot.ChemodanCommonContextConfiguration;
import ru.yandex.chemodan.boot.ChemodanMainSupport;
import ru.yandex.misc.db.monica.JdbcMetricsSwitch;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.SimpleAppName;

/**
 * @author tolmalev
 */
public class DataApiWorkerMain extends ChemodanMainSupport {

    public static void main(String[] args) {
        JdbcMetricsSwitch.ENABLED = true;
        JdbcMetricsSwitch.COMMAND_METRICS_ENABLED = true;
        new DataApiWorkerMain().runMain(args);
    }

    @Override
    public ListF<Class<?>> applicationSpecificContextPath() {
        return Cf.list(
                ChemodanCommonContextConfiguration.class,
                DataApiMonicaMasterContextConfiguration.class,
                DataApiWorkerContextConfiguration.class,
                RestoreManagerContextConfiguration.class);
    }

    @Override
    protected void postProcessApplicationContextBeforeRefresh(ConfigurableApplicationContext context) {
        super.postProcessApplicationContextBeforeRefresh(context);

        context.getEnvironment().addActiveProfile("dataapi");
    }

    public AppName applicationName() {
        return new SimpleAppName("dataapi", "dataapi-worker");
    }

    @Override
    protected void configureLogger() {

        super.configureLogger();

        DataapiLog4jHelper.configureDatabaseChangesTskvLogger(applicationName());
    }
}
