package ru.yandex.chemodan.app.dataapi.worker;

import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.Snapshot;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.dao.data.DatabasesJdbcDao;
import ru.yandex.chemodan.app.dataapi.core.dao.test.ActivateDataApiEmbeddedPg;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.dataapi.test.DataApiTestSupport;
import ru.yandex.chemodan.app.dataapi.test.FullContextTestsContextConfiguration;
import ru.yandex.devtools.test.annotations.YaIgnore;

/**
 * 564979
 * 53332753
 * 120172677
 * 162672826
 * 196445359
 *
 */
@YaIgnore
@ActivateDataApiEmbeddedPg
@ContextConfiguration(classes = {FullContextTestsContextConfiguration.class, RestoreManagerTest.Config.class})
public class RestoreManagerTest extends DataApiTestSupport {

    @Autowired
    public RestoreManager restoreManager;
    @Test
    public void applyDeltaRaw() {
        RestoreManager.Data data = new RestoreManager.Data();
        data.setMethod("update");
        data.setRecordData("[{\"field_id\":\"title\",\"value\":{\"type\":\"string\",\"string\":\"xxx\"}},{\"field_id\":\"children\",\"value\":{\"type\":\"list\",\"list\":[{\"type\":\"string\",\"string\":\"the_favorites_folder\"}]}}]");
        data.setRecord_id("the_root_folder");
        data.setRecord_rev(1);
        Assert.assertNotNull(data);
    }

    /**
     * {
     *   "a.method": "insert",
     *   "a.record_data": "[{\"field_id\":\"description\",\"value\":{\"type\":\"string\",\"string\":\"\"}},{\"field_id\":\"title\",\"value\":{\"type\":\"string\",\"string\":\"\u0422\u0414 \u0413\u0435\u0440\u043C\u0435\u0441 18 \u043A\u043C \u041C\u041A\u0410\u0414 \u0421\u043F\u043E\u0440\u0442 \u042D\u043A\u0441\u0442\u0440\u0438\u043C\"}},{\"field_id\":\"uri\",\"value\":{\"type\":\"string\",\"string\":\"ymapsbm1:\/\/pin?ll=37.79847543%2C55.62487536\"}}]",
     *   "a.record_id": "_ilH6Pgb1SrqbhhXtxnGbVQsFUoDbeiQ",
     *   "a.record_rev": 660,
     *   "a.uid": "196445359",
     *   "a.unixtime": "1511508574"
     * }
     */
    @Test
    public void loadData() {
        String data = "/arcadia/disk/dataapi/worker/src/main/java/ru/yandex/chemodan/app/dataapi/worker/data_10033243.json";
        MapF<DataApiUserId, Snapshot> result = restoreManager.restoreUsers(data);

        Assert.assertTrue(result.isNotEmpty());
        result = restoreManager.restoreUsers(data);
        Assert.assertFalse(result.isNotEmpty());
    }
    @Test
    public void fixUser() {
        String data = "/arcadia/disk/dataapi/worker/src/main/java/ru/yandex/chemodan/app/dataapi/worker/data_10033243.json";
        MapF<DataApiUserId, Snapshot> result = restoreManager.restoreUsers(data);
        Assert.assertTrue(result.isNotEmpty());


        result = restoreManager.restoreListOfUsers(Cf.list("10033243"));
        Assert.assertTrue(result.isEmpty());

        result = restoreManager.restoreListOfUsers(Cf.list("10033244"));
        Assert.assertTrue(result.isNotEmpty());
    }


    @Configuration
    public static class Config {

        @Autowired
        public DataApiManager dataApiManager;
        @Autowired
        public DatabasesJdbcDao databasesJdbcDao;

        @Bean
        public RestoreManager restoreManager() {
            return new RestoreManager(dataApiManager, databasesJdbcDao);
        }
    }
}
