#!/bin/sh -e
#
# java OOM killer
# -XX:OnOutOfMemoryError="SOME-PATH/java-oom-handler.sh -p %p"
# do not use directly
#

ec() {
    echo "$@" >&2
    "$@"
}

err_exit() {
    echo "$@" >&2
    exit 1
}

usage() {
    err_exit \
"Usage: $(basename $0) -p PID [-s SLEEP_BEFORE_KILL]
script for handling java OOM, do not use directly"
}

test_pid() {
    ps -p "$1" >/dev/null 2>&1
}

pid=
terms_before_kill=5

while getopts hp:s: param
do
    case $param in
        p) pid="$OPTARG" ;;
        s) terms_before_kill="$OPTARG" ;;
        h) usage ;;
        ?) usage ;;
    esac
done

[ -z "$pid" ] && usage

echo "Begin to shutdown $pid pid"

test_pid "$pid" || err_exit "Can't find process with pid $pid"

# seq don't exists in BSD
sequence=$(awk "BEGIN { for (i=1; i<=$terms_before_kill; i++) print i; exit }")

for i in $(echo "$sequence"); do
    test_pid "$pid" || break
    ec kill -TERM "$pid"
    ec sleep 1
done

test_pid "$pid" && ec kill -KILL "$pid"

# vim: set ts=4 sw=4 et:
