#!/bin/sh

case "$1" in
"-p")
    echo "# Stage states: I=initial, P=in progress, T=temporary failure, F=permanent failure, SF=skipped (failure), S=success, D=disabled"
    if [ "$2" = "V1" ]; then
        echo "# Format: id, age, type, stages with their states"
        curl -s "http://127.0.0.1:32450/queue/v1"
    else
        echo "# Format: id, creation time, time until next retry [0], failed attempts [0], type, current stage with state [Success]"
        curl -s "http://127.0.0.1:32450/queue"
    fi
    ;;
"-c")
    curl -s "http://127.0.0.1:32451/sensor/queueSensors.incompleteRequestsCount()"
    ;;
"-q")
    curl -s "http://127.0.0.1:32450/request-status/$2"
    ;;
"-f")
    if [ $2 = "ALL" ]; then
        curl -dcommand=flush "http://127.0.0.1:32450/queue" && echo "OK; all suspended items flushed"
    else
        curl -dcommand=flush "http://127.0.0.1:32450/queue/$2" && echo "OK; item(s) flushed"
    fi
    ;;
"-d")
    curl -X DELETE "http://127.0.0.1:32450/queue?id=$2" && echo "OK; item(s) deleted"
    ;;
"-dd")
    if [ $2 = "ALL" ]; then
        curl -dcommand=cancel "http://127.0.0.1:32450/queue" && echo "OK; all items canceled; callbacks sent"
    else
        curl -dcommand=cancel "http://127.0.0.1:32450/queue/$2" && echo "OK; item(s) deleted; callback sent"
    fi
    ;;
*)
    echo "usage:"
    echo "-p [V1]   show queue contents (V1 stands for old format)"
    echo "-c        show queue size"
    echo "-q <id>   show item"
    echo "-f <...>  flush given item, or ALL"
    echo "-d <id>   delete item"
    echo "-dd <id>  cancel item (delete and send callback), or ALL"
esac
