#! /usr/bin/python

from optparse import OptionParser, Option
from pymongo import MongoClient
import datetime

option_list = (
    Option(
        "-l", "--link",
        type="string", action="store",
        dest="link", help="file link"
    ),
    Option(
        "-t", "--type",
        type="string", action="store",
        dest="type", help="file type"
    )
)

usage = "usage: %prog -l link -t type"
parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()


def main(host, link, fileType):
    client = MongoClient(host)
    moderation_queue = client["support_moderation_queue"]["support_moderation_queue"]
    moderation_item = {
        "created": datetime.datetime.utcnow(),
        "source": "public_views",
        "links": [{"type": fileType, "url": link}],
        "status": "not-moderated",
    }
    moderation_queue.insert(moderation_item)


if __name__ == "__main__":
    link = options.link
    fileType = options.type
    host = 'miscdb01g.disk.yandex.net:27018,miscdb01d.disk.yandex.net:27018,miscdb01e.disk.yandex.net:27018'
    assert link
    assert fileType
    print "Put %s %s to moderation queue on host %s" % (fileType, link, host)
    main(host, link, fileType)
