#!/bin/bash -e

set -e

ec() {
    echo "$@"
    "$@"
}

cd $(dirname $0)
cd ..

if [ -z $1 ]; then
    echo "Select branch to build!"
    exit 1
fi

branch=$1
shift

if [ $branch = "master" ]; then
    if [ -z $1 ]; then
        echo "Can't build master without component!"
        exit 1
    fi
    component=$1
    shift
fi

if [ -z $component ]; then
    if [[ $(echo $branch | grep ^release[-_].*[-_][^-_]*$) ]]; then
        component=$(echo $branch | sed 's/^release[-_]\(.*\)[-_][^-_]*$/\1/')
    else
        echo "branch name must be release_{component}_{version}"
        exit 1
    fi
fi

if [ $1 == $component ]; then
    shift
fi

if [ $(devel/get_current_branch.sh) != $branch ]; then
    ec devel/switch_branch.sh $branch
fi

ec devel/ya svn revert . --recursive

ec devel/inc_changelog_version.sh

SVN_REVISION=$(LANGUAGE=en_EN.UTF-8 devel/ya svn info | sed -n 's/^Last Changed Rev: \(.*\)$/\1/p')
version=$(devel/deb_version.sh)
echo "##teamcity[buildNumber '$version-']"

DEBEMAIL=teamcity@yandex-team.ru devel/package/build_component.py $component "$@"

if [ $branch != "master" ]; then
    ec devel/switch_branch.sh master
fi
