#!/usr/bin/python
# -*- coding: utf-8 -*-


from common import component_packages

import ConfigParser
import sys,traceback
import os
import platform
import re

from time import sleep, ctime, time

if __name__ == "__main__":
    dirname=os.path.dirname(sys.argv[0])
    branch = os.popen(dirname + '/get_current_branch.sh').readline().strip()
    if branch == "master":
        print "building all packages"
        if len(sys.argv) > 1 and sys.argv[1] == "--for-teamcity":
            os.system(dirname + '/../teamcity-build.sh')
        else:
            os.system(dirname + '/../build-debs.sh')
    else:
        match = re.search('^release[_-](.+)[_-][^_-]+$', branch)
        if not match:
            print "release branch must match pattern release_{component}_{version}"
            sys.exit(1)
        component = match.group(1)
        print "building packages for component", component

        script = dirname + "/build_several_packages.sh "
        if len(sys.argv) > 1 and sys.argv[1] == "--for-teamcity":
            script += "--for-teamcity "

        for package in component_packages[component]:
            script += package + " "

        print 'running script', script
        os.system(script)
