#!/bin/bash
#set -e

ec() {
    echo "$@"
    "$@"
}

err_exit() {
    echo "$@" >&2
    exit 1
}

usage() {
    echo "Usage: $(basename $0) <package_name 1> <package_name 2> ..."
    exit 1
}

for_teamcity=false
if [ $1 == "--for-teamcity" ]; then
    echo "Building for teamcity!"
    for_teamcity=true
    shift 
fi

[ $# -ne 0 ] || usage

root_dir=$(dirname $0)/..
control_file=$root_dir/debian/control

for package in "$@"; do
    if [[ $(grep "^Package: $package$" $control_file -c) == "0" ]]; then
        err_exit "Unknown package '$package'"
    fi
done

echo "Building packages '$@'"
echo "--------------------------------------------------"

tmp_dir=$root_dir/tmp/tmp.deb.split.control

rm -rf $tmp_dir
mkdir -p $tmp_dir

one_package_control_file=$tmp_dir/control-current-build

cat $control_file | sed -n '1,/^$/ p' > $one_package_control_file
for package in "$@"; do
    cat $control_file | sed -n '/Package: '$package'$/,/^$/ p' >> $one_package_control_file
    echo "" >> $one_package_control_file
done;

echo "Created separate control file: '$one_package_control_file'"

cat $one_package_control_file

control_file_backup=$tmp_dir/control-all

mv $control_file $control_file_backup
echo "Created backup of debian/control file: $control_file_backup"
mv $one_package_control_file $control_file
echo "One package control file moved to debian/control"

echo "------------------------------------------------"
echo ""
echo "Building package"

if [ $for_teamcity ]; then
    ec $root_dir/teamcity-build.sh --allow-uncommitted
else
    ec $root_dir/build-debs.sh
fi

if [[ $? != 0 ]]; then
    success=false
else
    success=true
fi

echo "------------------------------------------------"

mv $control_file_backup $control_file
echo "Restored real debian/control file"

rm -rf $tmp_dir

if [[ $success == false ]]; then
    echo "" >&2
    err_exit 'Fatal: Failed to build package'
fi

# vim: set ts=4 sw=4 et:
