#2014-04-18 00:06:03,023 20140417T200429.164.utd.bajt4raktqpglpwp0aad45pc7-k1h.375160 type=UploadToDefault, stage=payloadInfo, duration=0.111, content_length=6571905, mime-type=audio/mpeg, success=true
#2014-04-16 00:05:45,214 20140415T200543.246.utd.77w9mapjripvmd0f4z2lqcr3o-k1h.104455 type=UploadToDefault, stage=pp.commitFileUpload, duration=0.271, status_line="HTTP/1.1 200 OK", uri=Some(http://mpfs.disk.yandex.net:80/service/kladun_callback?uid=107338930&oid=d2719be39fbe98a00d66a75553b7e3b48dcd5f23396c4731720df731c55c1564), success=true

%archives = map { $_ => 1 } (
	    "application/x-7z-compressed", "application/x-debian-package",
            "application/x-bzip", "application/x-bzip2",
            "application/x-gzip", "application/gzip", "application/x-gunzip", "application/gzipped", "application/gzip-compressed", "gzip/document", "application/x-iso9660-image", "application/x-tar",
            "application/x-rar", "application/x-rar-compressed",
            "application/x-rpm",
            "application/zip", "application/x-zip", "application/x-zip-compressed");
%documents = map { $_ => 1 } (
	    "application/vnd.oasis.opendocument.text", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
             "text/html", "text/plain", "application/pdf", "application/vnd.ms-excel", "application/msword");

%books = map { $_ => 1} ("application/epub+zip", "application/x-fictionbook+xml", "application/x-mobipocket-ebook", "application/vnd.amazon.ebook");
%exe = map { $_ => 1} ("application/com", "application/x-msdownload", "application/x-msdos-program");

sub mediaType {
    my ($mimeType) = @_;
    if ($mimeType =~ /^image\//) {
        return "image";
    } elsif ($mimeType =~ /^video\//) {
        return "video";
    } elsif ($mimeType =~ /^audio\//) {
        return "audio";
    } elsif (exists($archives{$mimeType})) {
        return "archive";
    } elsif (exists($documents{$mimeType})) {
        return "document";
    } elsif (exists($books{$mimeType})) {
        return "book";
    } elsif (exists($exe{$mimeType})) {
        return "executable";
    } else {
        return "other";
    }
}

while($line=<STDIN>) {
    chomp($line);

    if ($line =~ /([\S]+) type=UploadToDefault, stage=payloadInfo.* content_length=(.*), mime-type=(.*),/) {
        $task_size{$1} = $2;
        $task_type{$1} = mediaType($3);
    } elsif ($line =~ /([\S]+) type=UploadToDefault, stage=pp.commitFileUpload/) {
        # Calculate only tasks, that was uploaded to mulca
	    $size{$task_type{$1}} += $task_size{$1};
    }
}

foreach $key (sort { $size {$b} <=> $size {$a}} keys %size ) {
    my $inGb = $size{$key} / (1024 * 1024 * 1024);
    printf("$key : %.2f gb\n", $inGb);
    $total += $inGb;
}

printf("\ntotal : %.2f gb\n", $total);

