#!/usr/bin/python
# -*- coding: utf-8 -*-


from common import component_packages

import sys,traceback
import os
from optparse import OptionParser, Option

usage = "usage: %prog -h"

option_list = (
    Option(
        '-c', '--component',
        action='store',
        dest='component',
        type='string',
        default=None,
        help='Component name'
    ),
    Option(
        '-v', '--version',
        action='store',
        dest='version',
        type='string',
        default=None,
        help='Version of release'
    ),
    Option(
        '-r', '--revisions',
        action='store',
        dest='revisions',
        type='string',
        default=None,
        help='comma-separated list of revisions to cherry-pick'
    ),

)

parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()

def release_branch(package, version):
    return 'release-' + package + '-' + version

def os_execute(command):
    if os.system(command) != 0:
        print 'Failed to execute "' + command + "'"
        sys.exit(1)

if __name__ == "__main__":
    if options.component and options.version and options.revisions:
        revisions = options.revisions.split(",")
        component = options.component

        if component not in component_packages:
            print 'Unknown component', component
            sys.exit(1)

        branches = [release_branch(package, options.version) for package in component_packages[component]]
        for branch in branches:
            print 'cherry-picking to branch', branch

            os_execute('git checkout ' + branch)
            os_execute('git pull --rebase')
            os_execute('git cherry-pick ' + ' '.join(revisions))

            print ''

        for branch in branches:
            print 'Pushing branch', branch, 'to server'

            os_execute('git checkout ' + branch)
            os_execute('git push origin ' + branch)
            print ''

        os.system('git checkout master')
    else:
        parser.print_usage()
