import getopt
import sys
import os
import json

def print_usage_and_exit():
    print os.path.basename(__file__) + ' (current|next_minor)'
    quit(1)

if len(sys.argv) < 2:
    print_usage_and_exit()

opts, args = getopt.getopt(sys.argv[2:], 'p', ['path='])

project_path = '.'
for opt, arg in opts:
    if opt in ('-p', '--path'):
        project_path = arg

with open(project_path + '/project.json') as project_config:
    curr_ver = json.load(project_config)['version']

if sys.argv[1] == 'current':
    print curr_ver
elif sys.argv[1] == 'next_minor':
    print '-'.join(curr_ver.split('-')[:-1] + [str(int(curr_ver.split('-')[-1]) + 1)])
else:
    print_usage_and_exit()
