#!/bin/sh

export CLASSPATH=common/target/jars/yandex-chemodan.jar:`find common/lib -name \*jar | xargs echo | sed 's/ /:/g'`

if [ $# -lt 1 ]; then
    echo "usage: d.sh uploader.Main [args...]" >&2
    exit 1
fi

WHAT=$1
shift

#export JVMARGS="$JVMARGS -Xmx3300m"

#$JAVA_HOME/bin/
java -showversion -server \
    -XX:+UseParallelGC -XX:-UseGCOverheadLimit -XX:+HeapDumpOnOutOfMemoryError \
    -Dfile.encoding=UTF-8 \
    -Dnetworkaddress.cache.ttl=600 -Djava.net.preferIPv4Stack=true \
    -Dsun.net.client.defaultConnectTimeout=5000 -Dsun.net.client.defaultReadTimeout=5000 \
    $JVMARGS -classpath $CLASSPATH ru.yandex.chemodan.$WHAT $@
