importPackage(ru.yandex.misc.db.masterSlave);
importPackage(ru.yandex.chemodan.app.dataapi.database);
importClass(ru.yandex.misc.db.q.SqlCondition);

handle = MasterSlaveContextHolder.push(MasterSlavePolicy.R_S);

try {
    var jdbcTemplate = dataShardManager.getShard(1).getJdbcTemplate3();

    var file = new File2("/tmp/all_databases");

    for (var i = 1; i <= 128; i++) {
        var table = partitionResolver.partitionTableNameForDiscriminant("databases", i);
        var q = new java.lang.String("SELECT * from " + table);

        var databases = jdbcTemplate.query(q, DatabaseMapper.FROM_REAL, SqlCondition.trueCondition().args());

        out = file.asAppendOutputStreamTool().asWriterTool();
        out.writeLines(databases.map(
            function (d) {
                return "puid=" + d.uid + "\t"
                    + "rev=" + d.rev + "\t"
                    + "app=" + d.appNameO().getOrElse("global") + "\t"
                    + "db_id=" + d.aliasId() + "\t"
                    + "records_count=" + d.meta.recordsCount + "\t"
                    + "size=" + d.meta.size.toBytes();
            }
        ))
    }
} finally {
    handle.pop();
}

