#!/usr/bin/python
# -*- coding: utf-8 -*-
# 'https://c.yandex-team.ru/api/groups2hosts/disk_dataapi?format=json'

# upstream dataapi07h.disk.yandex.net {
#     server dataapi07h.disk.yandex.net:21859 max_fails=3 fail_timeout=300s;
#     server 127.0.0.1:21860 backup;
#     keepalive 64;
# }


import json
import requests

api_url = 'https://c.yandex-team.ru/api/groups2hosts/disk_dataapi?format=json'

headers = {'Content-Type': 'application/json'}

def get_hosts():

    response = requests.get(api_url, headers=headers)

    if response.status_code == 200:
        res = json.loads(response.content.decode('utf-8'))
        return res
    else:
        return None

account_info = get_hosts()

if account_info is not None:
    for k in account_info:
        server_name = k['fqdn']
        print('upstream ' + server_name + " {")
        print('  server ' + server_name + ':21859 max_fails=1 fail_timeout=300s;')
        print('  server 127.0.0.1:21859 backup;')
        print('  keepalive 64;')
        print("}")

else:
    print('[!] Request Failed')
