importPackage(ru.yandex.chemodan.app.dataapi.api.user);
importPackage(ru.yandex.chemodan.app.dataapi.utils.dataconversion);
importPackage(ru.yandex.misc.db.q);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter.ordering)

type = "market/delivery_addresses";

f = new File2("/tmp/addresses");
list = f.readLines();

function same(a1, a2) {
    n1 = JsonNodeUtils.getNode(a);
    n2 = a2;

    return true
        && n1.get("city").textValue().equals(n2.get("city").textValue())
        && n1.get("country").textValue().equals(n2.get("country").textValue())
        && n1.get("street").textValue().equals(n2.get("street").textValue())
        && n1.get("building").textValue().equals(n2.get("building").textValue())
        ;
}

function containsAddress(addresses, address) {
    print(addresses);
    for each (a in addresses.result) {
        if (same(a, address)) {
            return true;
        }
    }
    return false;
}

for (var i = 0; i < list.size(); i++) {
    split = list.get(i).split("\t");
    uid = DataApiUserId.parse(split[0]);
    try {
        addresses = JsonNodeUtils.getNode(split[1]).get("addresses");
        for (var j = 0; j < addresses.size(); j++) {
            id = addresses.get(j).get("id").textValue();

            realAddresses = genericDataManager.getList(uid, type, SqlLimits.all(), IdQueries.empty());

            if (!containsAddress(realAddresses, addresses.get(j))) {
                genericDataManager.set(uid, id, type, addresses.get(j).toString());
                print ("added address " + addresses.get(j));
            } else {
                print ("not added address " + addresses.get(j));
            }
        }
    } catch(e) {
        print(e);
        print(list.get(i));
        if (!e.getMessage().contains("Invalid id")) {
            throw e;
        }
    }
}

