importClass(ru.yandex.misc.log.mlf.LoggerFactory);
importPackage(ru.yandex.chemodan.app.dataapi.api.db.ref);
importPackage(ru.yandex.chemodan.app.dataapi.api.user);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.record);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.field);
importPackage(ru.yandex.chemodan.app.dataapi.api.deltas);

var appName = 'yadisk';
var databaseId = 'common';

var collectionId = 'config_v3';
var recordId = 'windows';

var fieldId = 'News';

var logger = LoggerFactory.getLogger("news-cleaner");
var counter = new java.util.concurrent.atomic.AtomicInteger(0);
var withNewsCounter = new java.util.concurrent.atomic.AtomicInteger(0);

function removeWindowsNews(raw_uid) {
    var uid = DataApiUserId.parse('' + raw_uid);
    logger.info('removing news: {} uid={}, really removed before {}', counter.incrementAndGet(), uid, withNewsCounter.get());

    var dbRef =  DatabaseRef.cons(Option.of(appName), databaseId);
    var userDbSpec = new UserDatabaseSpec(uid, dbRef);
    var databaseO = dataApiManager.getDatabaseO(userDbSpec);

    if (!databaseO.isPresent()) {
        return;
    }

    var database = databaseO.get();

    var recordO = dataApiManager.getRecord(uid, database.dbRef().consColRef(collectionId).consRecordRef(recordId));
    if (recordO.exists(function (record) {return record.getFields().getO(fieldId).isPresent()})) {
        withNewsCounter.incrementAndGet();
        var fieldChange = FieldChange.delete(fieldId);
        var recordChange = RecordChange.update(collectionId, recordId, fieldChange);
        var delta = new Delta(recordChange);
        dataApiManager.applyDelta(database, RevisionCheckMode.PER_RECORD, delta);
    }
};

var executer = java.util.concurrent.Executors.newFixedThreadPool(100, new ru.yandex.misc.thread.factory.ThreadNameIndexThreadFactory("news-cleaner"));

var uids = (new File2("/tmp/uids.txt")).readLines().flatMap(function(x){return Cf.Long.parseSafe(x)}).unique();

uids.forEach(function(uid) {
    var finalUid = uid
    executer.submit(new java.lang.Runnable(function() {removeWindowsNews(finalUid);}));
});

executer.shutdown();
logger.info('really removed {}', withNewsCounter.get())
