importPackage(ru.yandex.chemodan.app.dataapi.api.db.ref);
importPackage(ru.yandex.chemodan.app.dataapi.api.user);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.record);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.field);
importPackage(ru.yandex.chemodan.app.dataapi.api.deltas);

var appName = 'yadisk';
var databaseId = 'common';

var collectionId = 'config_v3';
var recordId = 'common';

var fieldId = 'UseRestDiffsForce';
var fieldValue = '1';

Cf.list(
    'uid_1', 'uid_2', 'uid_3'
).forEach(function (uid_str) {
    var uid = DataApiUserId.parse(uid_str);
    var dbRef =  DatabaseRef.cons(Option.of(appName), databaseId);
    var userDbSpec = new UserDatabaseSpec(uid, dbRef);
    var database = dataApiManager.getOrCreateDatabase(userDbSpec);
    //----------------------------------------

    var recordChange;
    // Если объект уже есть - надо обновить поле
    // Если нет - создать новый объект
    var recordO = dataApiManager.getRecord(uid, database.dbRef().consColRef(collectionId).consRecordRef(recordId));
    if (recordO.isPresent()) {
        var fieldChange = FieldChange.put(fieldId, DataField.string(fieldValue));
        recordChange = RecordChange.update(collectionId, recordId, fieldChange);
    } else {
        recordChange = new SimpleDataRecord(collectionId, recordId, NamedDataField.string(fieldId, fieldValue)).toInsertChange();
    }

    var delta = new Delta(recordChange);

    dataApiManager.applyDelta(database, RevisionCheckMode.PER_RECORD, delta);
});

