import Queue
import json
import threading
import traceback
import urlparse

from compare_mpfs_djfs_bulk import get_data, MPFS_HOST, DJFS_HOST, same, remove_duplicates_in_file_ids

errors_write_lock = threading.Lock()
console_lock = threading.Lock()


def write_error_line(line):
    with errors_write_lock:
        with open('errors.log', 'a') as f:
            f.write(line)


class CompareTread(threading.Thread):
    def __init__(self, lines_queue, results_queue, results_thread):
        threading.Thread.__init__(self)
        self.lines_queue = lines_queue
        self.results_queue = results_queue
        self.daemon = True
        self.receive_messages = True
        self.source_file_ended = False
        self.results_thread = results_thread

    def run(self):
        while self.receive_messages:
            if self.source_file_ended:
                self.results_thread.dec_running_comparators()
                return

            try:
                val = self.lines_queue.get(timeout=5)
                self.process_message(val['_id'], val['line'])
            except Queue.Empty as e:
                print 'queue is empty'
                if self.source_file_ended:
                    return

    def process_message(self, _id, line):
        try:
            uri, paths = line[:-1].split('\t')
            body = remove_duplicates_in_file_ids(paths)
            uid = urlparse.parse_qs(urlparse.urlparse(uri).query)['uid'][0]

            mpfs_response = get_data(MPFS_HOST, uri, body)
            djfs_response = get_data(DJFS_HOST, uri, body)

            if not mpfs_response and not djfs_response:
                self.report_success(_id)
                return
            if not mpfs_response or not djfs_response:
                self.report_error('ERROR in one of responses, ID :', _id, line)
                return

            mpfs_data = json.loads(mpfs_response.text)
            djfs_data = json.loads(djfs_response.text)

            if same(mpfs_data, djfs_data, uid):
                self.report_success(_id)
            else:
                self.report_error('NOT_MATCHED: ', _id, line)
        except Exception as e:
            self.report_error('ERROR: ', _id, line, e)

    def stop(self):
        self.receive_messages = False

    def source_file_ended(self):
        self.source_file_ended = True

    def report_error(self, message, _id, line, exception=None):
        self.results_queue.put(_id)
        with console_lock:
            print message + str(_id)
            if exception:
                print exception
                traceback.print_exc()
        write_error_line(line)

    def report_success(self, _id):
        self.results_queue.put(_id)
        if (_id % 5000 == 0):
            with console_lock:
                print 'SUCCESS: ' + str(_id)
