#! /usr/bin/env python2.7
# -*- coding: utf8 -*-
import Queue
import sys
import time

from dsamuylov.old.compare_thread import CompareTread
from dsamuylov.old.dump_lines_thread import DumpResultsThread

reload(sys)
sys.setdefaultencoding('utf-8')

THREADS = 40


def read_last_unprocessed():
    try:
        with open('last_unprocessed.txt', 'r') as f:
            lines = f.readlines()
            offset = int(lines.pop())
            print 'read last unprocessed: ' + str(offset)
            return offset
    except Exception as e:
        print 'using command line parameter: ' + str(int(sys.argv[1]))
        return int(sys.argv[1])


def init_compare_threads(messages_queue, results_queue, results_thread):
    threads = []
    for t in range(THREADS):
        threads.append(CompareTread(messages_queue, results_queue, results_thread))
        threads[t].start()
        time.sleep(0.1)
    return threads


def init_dump_results_thread(queue, init_offset):
    thread = DumpResultsThread(queue, init_offset, THREADS)
    thread.start()
    return thread


def parallel_check(lines):
    offset = read_last_unprocessed()
    lines_queue = Queue.Queue(THREADS * 50)
    results_queue = Queue.Queue()

    dump_results_thread = init_dump_results_thread(results_queue, offset)
    compare_threads = init_compare_threads(lines_queue, results_queue, dump_results_thread)

    for _id, line in enumerate(lines):
        if _id < offset:
            continue

        try:
            lines_queue.put({'_id': _id, 'line': line}, block=True, timeout=60)
        except Queue.Full as e:
            for t in compare_threads: t.stop()
            dump_results_thread.stop()
            print 'Queue overflow'
            return

    dump_results_thread.join()
    for t in compare_threads:
        t.join()
        t.source_file_ended()


if __name__ == "__main__":
    parallel_check(sys.stdin)
    print 'done'
