#!/bin/bash
set -e

ec() {
    echo "$@"
    "$@"
}

err_exit() {
    echo "$@" >&2
    exit 1
}

cd $(dirname $0)
cd ..

if [[ $1 != "--for-temcity" ]]; then
    devel/ya svn up
fi

version=$(devel/deb_version.sh)
prefix=$(echo $version | sed 's/\(.*\)\.\([^\.]*\)/\1/')
suffix=$(echo $version | sed 's/\(.*\)\.\([^\.]*\)/\2/')

new_suffix=$(( $suffix + 1 ))
new_version=$prefix.$new_suffix

echo "$version -> $new_version"

ec devel/set_changelog_version.sh $new_version

ec devel/ya svn commit debian/changelog -m "ver++ (current version: $new_version) SKIP_CHECK"
