import re

from os import listdir
from os.path import isfile, join

PATH = '/Users/lemeh/Downloads/blocked_ips'
IPS_REGEX = re.compile('^([^,]+), got (.+)$')


class IpCounter:
    def __init__(self):
        self.actual_ips = set()
        self.total_count = 0

    def add(self, ip):
        self.total_count = self.total_count + 1
        self.actual_ips.add(ip)

    @property
    def unique_count(self):
        return len(self.actual_ips)


expected_ip_to_actual = {}
for item in listdir(PATH):
    item_path = join(PATH, item)
    if not isfile(item_path) or not item.endswith('.txt'):
        continue

    with open(item_path) as f:
        for line in f:
            m = IPS_REGEX.match(line)
            expected_ip, actual_ip = m.group(1), m.group(2)
            if expected_ip not in expected_ip_to_actual:
                expected_ip_to_actual[expected_ip] = IpCounter()

            expected_ip_to_actual[expected_ip].add(actual_ip)

normal = 0
bad = 0

groups = []
for expected_ip, counter in expected_ip_to_actual.iteritems():
    in_actual = False
    for other_expected_ip, other_counter in expected_ip_to_actual.iteritems():
        if expected_ip in other_counter.actual_ips:
            in_actual = True
            break

    if in_actual:
        in_group = False
        for group in groups:
            if expected_ip in group:
                in_group = True
                group.update(counter.actual_ips)

        if not in_group:
            group = set()
            group.add(expected_ip)
            group.update(counter.actual_ips)
            groups.append(group)

for group in groups:
    print ','.join(group)

for expected_ip, counter in expected_ip_to_actual.iteritems():
    #  	print '%d %d %s' % (counter.total_count, counter.unique_count, expected_ip)
    if counter.unique_count > 5:
        bad += counter.total_count
    else:
        normal += counter.total_count
# print expected_ip
# 		for ip in counter.actual_ips:
# 			print '\t%s' % ip

print 'normal = %d, bad = %d' % (normal, bad)
