#!/usr/bin/env bash
VERSION=$1
REPO_PATH=/Users/lemeh/Downloads/cocaine
COKE_PATH=$REPO_PATH/ru/yandex/cocaine
IVY_HOST=www-data@ivy.dev.yandex.net # password: data-www

for module in cocaine-hpack cocaine-core cocaine-client cocaine-worker cocaine-http-worker cocaine-services; do
    artifact_path=$COKE_PATH/$module/$VERSION
    mkdir -p $artifact_path
    artifact=$module-$VERSION
    scp $IVY_HOST:/usr/local/ivy/repo/trunk/ru.yandex.cocaine/$module/$VERSION/jars/$module.jar $artifact_path/$artifact.jar
    scp $IVY_HOST:/usr/local/ivy/repo/trunk/ru.yandex.cocaine/$module/$VERSION/sources/$module.jar $artifact_path/$artifact-sources.jar
    unzip -p $artifact_path/$module-$VERSION.jar META-INF/maven/ru.yandex.cocaine/$module/pom.xml >$artifact_path/$artifact.pom
done

# parent module
mkdir -p $COKE_PATH/$VERSION
curl -o $COKE_PATH/$VERSION/cocaine-$VERSION.pom https://raw.githubusercontent.com/akirakozov/cocaine-framework-java/master/pom.xml

for module in cocaine-hpack cocaine-core cocaine-client cocaine-worker cocaine-http-worker cocaine-services; do
    ya maven-import --remote-repository=file:///$REPO_PATH/,http://central.maven.org/maven2/ \
        --sandbox-owner=lemeh ru.yandex.cocaine:$module:$VERSION
done
