importClass(ru.yandex.misc.log.mlf.LoggerFactory);
importClass(ru.yandex.misc.bender.Bender)
importClass(ru.yandex.inside.yt.kosher.tables.types.BenderTableEntryType)
importClass(ru.yandex.inside.yt.kosher.cypress.YPath)
importClass(ru.yandex.chemodan.app.lentaloader.reminder.DiskSearchFileInfo)
importClass(ru.yandex.inside.yt.kosher.tables.YTableEntryTypes)
importClass(ru.yandex.inside.passport.PassportUid)
importClass(ru.yandex.misc.time.InstantInterval)
importClass(ru.yandex.misc.time.TimeUtils)

var logger = LoggerFactory.getLogger("yt_exporter");

ndays = 3650
in_path = ytPath = YPath.simple("//home/disk-dev/tolmalev/mobile_uids_part")
out_path = YPath.simple("//home/disk-dev/tolmalev/auto_thema/mass_search_info").append(true)

type = YTableEntryTypes.JACKSON

interval = new InstantInterval(Instant.now().minus(Duration.standardDays(ndays)), Instant.now())

now = Instant.now()
uids = Cf.arrayList()
ytClient.tables().read(Option.none(), false, in_path, YTableEntryTypes.JACKSON, function(it) {
    while (it.hasNext()) {
        uidO = Cf.Long.parseSafe(it.next().get("uid").asText())
        uids.addAll(uidO)
    }
})
logger.info("loaded uids list from yt in {}", TimeUtils.secondsStringToNow(now))

//uids = uids.take(1)

benderConfig = ru.yandex.inside.yt.kosher.tables.YTableEntryTypeUtils.getDefaultBenderConfiguration()
serializer = ru.yandex.misc.bender.Bender.jsonSerializer(java.lang.Class.forName("ru.yandex.chemodan.app.lentaloader.reminder.DiskSearchFileInfo"), benderConfig)

all_data = Cf.arrayList();

for (var i = 0; i < uids.size(); i++) {
    uidL = uids.get(i);
    logger.info("dumping uid={}", uidL)

    try {
        now = Instant.now()
        resp = diskSearchClient.findPhotosWithBeauty(PassportUid.cons(uidL), interval, Option.empty(), 0, 100000)

        logger.info("got from search uid={}, items={}, time={}", uidL, resp.hitsArray.size(), TimeUtils.secondsStringToNow(now))

        now = Instant.now()
        data = resp.hitsArray.map(function(obj) {
            node = ru.yandex.chemodan.util.json.JsonNodeUtils.getNode(serializer.serializeJson(obj))
            node.set("uid", new com.fasterxml.jackson.databind.node.TextNode(uidL.toString()))
            node.remove("name")
            return node;
        })

        all_data.addAll(data);

        if (all_data.size() > 100000 || i == uids.size() - 1) {
            for (var t = 0; t < 10; t++) {
                try {
                    ytClient.tables().write(out_path, type, data)
                    logger.info("wrote to yt {} items, time={}", all_data.size(), TimeUtils.secondsStringToNow(now))
                    break;
                } catch (e) {
                    logger.error("Failed to write to yt: {}", e)
                    ru.yandex.misc.thread.ThreadUtils.sleep(1000)
                }
            }

            all_data = Cf.arrayList();
        }
    } catch(e) {
        logger.error("Failed to dump uid={}: {}", uidL, e)
    }
}