importClass(ru.yandex.misc.bender.Bender)
importClass(ru.yandex.misc.log.mlf.LoggerFactory);
importClass(ru.yandex.inside.yt.kosher.tables.types.BenderTableEntryType)
importClass(ru.yandex.inside.yt.kosher.cypress.YPath)
importClass(ru.yandex.chemodan.app.lentaloader.reminder.DiskSearchFileInfo)
importClass(ru.yandex.inside.yt.kosher.tables.YTableEntryTypes)
importClass(ru.yandex.inside.passport.PassportUid)
importClass(ru.yandex.misc.time.InstantInterval)

var logger = LoggerFactory.getLogger("photo-extracter");
var executer = java.util.concurrent.Executors.newFixedThreadPool(10, new ru.yandex.misc.thread.factory.ThreadNameIndexThreadFactory("photo-extracter"));

uids = yandexStaffUserRegistry.getAllExternalUids().map(function(pu) {return pu.getUid()})

type = YTableEntryTypes.bender(java.lang.Class.forName("ru.yandex.chemodan.app.lentaloader.reminder.DiskSearchFileInfo"))

function dumpUid(uidL) {
    var path = "//home/disk-dev/tolmalev/hackathon/" + uidL + "_all_photos"
    var ypath = YPath.simple(path)

    try {
        if (ytClient.cypress().exists(ypath)) {
            logger.info("uid already in yt: {}", uidL)
            return
        }
    } catch(e) {
        logger.warn("Failed to check in yt: {}", e)
    }

    var now = Instant.now()
    var items = Cf.arrayList()

    for (var i = 0; i < 30; i++) {
        for (var j = 0; j < 5; j++) {
            try {
                var interval = new InstantInterval(Instant.now().minus(Duration.standardDays(365 * (i + 1))), Instant.now().minus(Duration.standardDays(365 * (i))))
                var resp = diskSearchClient.findPhotosWithBeauty(PassportUid.cons(uidL), interval, Option.empty(), 0, 300000)
                items.addAll(resp.hitsArray)
                logger.info("rececived from search, uid={}, i={}", uidL, i)
                break;
            } catch (e) {
                logger.warn("Failed to get info from search, uid={}, i={} : {}", uidL, i, e)
                ru.yandex.misc.thread.ThreadUtils.sleep(1000)
            }
        }
    }
    if (items.size() > 3000) {
        for (var j = 0; j < 5; j++) {
            try {
                ytClient.tables().write(ypath, type, items)
                logger.info("stored to yt: {}", uidL)
                break;
            } catch (e) {
                logger.warn("Failed to store to yt: {}", e)
                ru.yandex.misc.thread.ThreadUtils.sleep(1000)
            }
        }
    }
}

uids.forEach(function(uid) {
    var finalUid = uid
    executer.submit(new java.lang.Runnable(function() {dumpUid(finalUid);}));
})

executer.shutdown();

