importPackage(ru.yandex.inside.yt.kosher.cypress);
importPackage(ru.yandex.inside.yt.kosher.tables);
importPackage(ru.yandex.chemodan.app.lentaloader.cool.model);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter.condition);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter);
importPackage(ru.yandex.chemodan.app.dataapi.api.deltas);
importClass(ru.yandex.misc.log.mlf.LoggerFactory);
importPackage(ru.yandex.chemodan.app.dataapi.api.db.ref);
importPackage(ru.yandex.inside.passport);
importPackage(ru.yandex.chemodan.app.dataapi.api.user);
importClass(ru.yandex.chemodan.app.lentaloader.cool.model.CoolLentaModelUtils);
importPackage(ru.yandex.chemodan.app.lentaloader.cool.log);
importPackage(ru.yandex.chemodan.app.lentaloader.lenta);
importPackage(ru.yandex.chemodan.app.dataapi.support);
importPackage(ru.yandex.chemodan.app.lentaloader.log);

var logger = LoggerFactory.getLogger("lenta-content-block-statistics");
//var executer = java.util.concurrent.Executors.newFixedThreadPool(10, new ru.yandex.misc.thread.factory.ThreadNameIndexThreadFactory("lenta-content-block-statistics"));

var filesCount = 0;
var blocksCount = 0;

function addUserContentBlockStatistics(rawUid) {
    logger.info("checking blocks for uid={}", rawUid)

    for (var i = 0; i < 5; i += 1) {
        try {
            var uid = new DataApiPassportUserId(Cf.Long.parse(rawUid + ""))
            var blocks = lentaManager.findBlocks(uid, LentaRecordType.CONTENT_BLOCK, FieldPredicate.field(RecordField.string("media_type")).eq("image"), ActionInfo.internal(ActionSource.photoReminders()));
            for (var j = 0; j < blocks.size(); j++) {
                blocksCount++;
                filesCount += blocks.get(j).specific.get('files_count').value;
            }
            return;
        } catch (e) {
            logger.info("retry fetching collection uid={}, {}", uid, e)
            java.lang.Thread.sleep(100);
        }
    }
    logger.info("failed to fetch blocks uid={}", uid)
};

DB_REF = new AppDatabaseRef("lenta", "lenta_blocks");

var step = 100;
var size = 9943;

for (var i = 0; i < size; i += step) {
    var path = YPath.simple("//home/disk-dev/messiahlap/content_blocks/stat_uids_2019_11_29").withRange(i, Math.min(i + step, size))

    nodes = Cf.arrayList()
    ytClient.tables().read(Option.none(), false, path, YTableEntryTypes.JACKSON, function(it) {
        while (it.hasNext()) {
            nodes.add(it.next())
        }
    })

    nodes.forEach(function(node) {
        var finalUid = node.get("uid").asText()

        //executer.submit(new java.lang.Runnable(function() {
            addUserContentBlockStatistics(finalUid)
            java.lang.Thread.sleep(25);
        //}))
    })
}

logger.info('files_count={}, blocks_count={}, avg={}', filesCount, blocksCount, filesCount / blocksCount);

//executer.shutdown();