importPackage(ru.yandex.chemodan.app.lentaloader.cool.model);
importPackage(ru.yandex.inside.passport);
importPackage(org.joda.time);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter.ordering);
importPackage(ru.yandex.chemodan.app.dataapi.api.db.ref);
importPackage(ru.yandex.chemodan.app.dataapi.api.user);
importPackage(ru.yandex.chemodan.app.lentaloader.cool);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter);
importPackage(ru.yandex.misc.db.q);
importPackage(ru.yandex.chemodan.app.lentaloader.cool.log);
importPackage(ru.yandex.chemodan.app.dataapi.api.deltas);

var createBlockForMorda = function(uid) {
	var passportUid = new PassportUid(uid);
	var block = coolLentaManager.createRandomBlockForUser(passportUid, 10, new DateTime(Instant.now(), userTimezoneHelper.getUserTimezone(passportUid)));
	var mordaBlock = block.toMinimalBlock().toMordaBlock(OrderedUUID.generateOrderedUUID(), Instant.now());
	var mordaDatabase = dataApiManager.getOrCreateDatabase(new UserDatabaseSpec(new DataApiPassportUserId(uid),  CoolLentaManager.MORDA_BLOCKS_DB_REF));
	var existingMordaBlocks = dataApiManager.getRecords(mordaDatabase.spec(), RecordsFilter.DEFAULT
                .withCollectionId(CoolLentaManager.MORDA_BLOCKS_COLLECTION_ID)
                .withRecordOrder(ByIdRecordOrder.RECORD_ID_DESC)
                .withLimits(SqlLimits.first(CoolLentaManager.MAX_MORDA_BLOCKS_COUNT))
        );
	var idByAllBlocksId
                = existingMordaBlocks.toMap(function(r) { return Tuple2.tuple(CoolLentaBlockFields.ALL_BLOCKS_ID.get(r), r.id.recordId()) });
    var blockByAllBlocksId = existingMordaBlocks.toMapMappingToKey(function(dr) { return CoolLentaBlockFields.ALL_BLOCKS_ID.get(dr) });
    var blockByBlocksId = existingMordaBlocks.toMapMappingToKey(function(r) { return r.id.recordId() });
    var changes = Cf.arrayList(CoolLentaModelUtils.blockToRecordChangeForMordaBlocks(mordaBlock));
    var events = Cf.arrayList(new CoolLentaBlockEvent(
                passportUid, CoolLentaEventType.MORDA_BLOCKS_ADD, mordaBlock
        ));
    var targetSize = existingMordaBlocks.size() + 1;
    if (blockByAllBlocksId.containsKeyTs(block.getId())) {
            // Found block with save id in list of existing. Remove it.
            var mordaBlockId = idByAllBlocksId.getTs(block.getId());
            changes.add(CoolLentaModelUtils.removeMordaBlockChange(mordaBlockId));
            events.add(new CoolLentaBlockEvent(
                    uid, CoolLentaEventType.MORDA_BLOCKS_DELETE,
                    CoolLentaModelUtils.recordToMordaBlock(blockByAllBlocksId.getTs(block.id))
            ));
            targetSize--;
    }
    if (targetSize > CoolLentaManager.MAX_MORDA_BLOCKS_COUNT) {
            // max limit reached - remove blocks
            var recordsIdToRemove = existingMordaBlocks.map(function(r) { return r.id.recordId() })
                    .sorted()
                    .take(targetSize - CoolLentaManager.MAX_MORDA_BLOCKS_COUNT);

            changes.addAll(recordsIdToRemove.map(function(id) { return CoolLentaModelUtils.removeMordaBlockChange(id) }));
            events.addAll(recordsIdToRemove.map(function(recordId) { return new CoolLentaBlockEvent(uid, CoolLentaEventType.MORDA_BLOCKS_DELETE,
                    CoolLentaModelUtils.recordToMordaBlock(blockByBlocksId.getTs(recordId))) }));
    }
    var rev = dataApiManager.applyDelta(mordaDatabase, RevisionCheckMode.PER_RECORD, new Delta(changes)).rev;
    CoolLentaEventLogger.log(events.map(function(event) { return event.withRevision(rev) }));
    return mordaBlock;
}
