importClass(ru.yandex.chemodan.app.dataapi.api.user.DataApiPassportUserId);
importClass(ru.yandex.chemodan.app.lentaloader.lenta.LentaRecordType);
importClass(ru.yandex.chemodan.app.dataapi.api.data.filter.condition.CollectionIdCondition);
importClass(ru.yandex.chemodan.app.lentaloader.lenta.LentaManagerImpl);
importClass(ru.yandex.chemodan.app.dataapi.api.data.filter.condition.DataCondition);
importClass(ru.yandex.chemodan.app.lentaloader.lenta.LentaBlockRecord);
importClass(ru.yandex.chemodan.app.dataapi.api.data.filter.RecordsFilter);
importClass(ru.yandex.chemodan.app.dataapi.api.db.ref.UserDatabaseSpec);
importClass(ru.yandex.chemodan.app.dataapi.api.db.ref.AppDatabaseRef);
importClass(ru.yandex.chemodan.mpfs.MpfsUser);
importClass(ru.yandex.chemodan.app.dataapi.api.deltas.RecordChange);
importClass(ru.yandex.chemodan.app.dataapi.api.deltas.RevisionCheckMode);
importClass(ru.yandex.chemodan.app.dataapi.api.deltas.Delta);

var dUid = new DataApiPassportUserId(3158635);

var collectionIdCond = CollectionIdCondition.all();

var dataCond = DataCondition.all()
                .and(LentaBlockRecord.Fields.TYPE.column().eq(LentaRecordType.PHOTO_SELECTION_BLOCK));

var filter = RecordsFilter.DEFAULT
                .withCollectionIdCond(collectionIdCond)
                .withDataCond(dataCond);

var DB_REF = new AppDatabaseRef("lenta", "lenta_blocks");
var maxDeltaSize = 10;

var totalDeleted = 0;
var totalMax = 234;
var nothingToDelete = false;
var totalChanges = Cf.arrayList();

while (!nothingToDelete) {
	var database = dataApiManager.getDatabaseO(new UserDatabaseSpec(dUid, DB_REF)).get();
    var handle = database.dbHandle;
    var userHandle = UserDatabaseSpec.fromUserAndHandle(dUid, handle);
    var blocks = dataApiManager.getRecords(userHandle, filter);

    var blocksToDelete = Cf.arrayList();
    var blocksToSkip = Cf.arrayList();

    blocks.forEach(function(block) {
        if (blocksToDelete.size() >= maxDeltaSize) {
            return;
        }
        var files = mpfsClient
            .bulkInfoByResourceIds(MpfsUser.of(dUid.toPassportUidOrZero()), Cf.set('file_id'),
                block.getData().getTs('resource_ids').listValue().map(function(value) { return value.stringValue() }),
                Cf.list("/disk", "/photounlim")
            );
        if (files.size() < 5) {
            blocksToDelete.add(block);
        } else {
            blocksToSkip.add(block)
        }
    });
    totalDeleted += blocksToDelete.size();

    if (blocksToDelete.isEmpty() || totalDeleted >= totalMax) {
        nothingToDelete = true;
        continue;
    }
    var changes = blocksToDelete.map(function(block) { return RecordChange.delete(block.getCollectionId(), block.getRecordId()) });
    //dataApiManager.applyDelta(database, RevisionCheckMode.WHOLE_DATABASE, new Delta(changes));
    totalChanges.add(changes);


}
totalChanges;

