importClass(ru.yandex.misc.log.mlf.LoggerFactory);
importClass(ru.yandex.chemodan.app.lentaloader.cool.CoolLentaManager)
importPackage(ru.yandex.chemodan.app.dataapi.api.db.ref)
importPackage(ru.yandex.inside.passport)
importPackage(ru.yandex.chemodan.app.dataapi.api.user)
importClass(ru.yandex.chemodan.app.lentaloader.cool.model.CoolLentaModelUtils)
importPackage(ru.yandex.chemodan.app.lentaloader.cool.log)

from_idx = 100000
limit = 100000

var uids = (new File2("/tmp/lenta_uids")).readLines().flatMap(function(x){return Cf.Long.parseSafe(x)}).drop(from_idx).take(limit).unique();
var logger = LoggerFactory.getLogger("lenta-export");
var executer = java.util.concurrent.Executors.newFixedThreadPool(100, new ru.yandex.misc.thread.factory.ThreadNameIndexThreadFactory("lenta-export"));

function logUidData(rawUid) {
    var pUid = PassportUid.cons(rawUid)
    var dUid = new DataApiPassportUserId(rawUid)
    for(var y = 0; y < 5; y++) {
        try {
            var events = dataApiManager.getRecords(new UserDatabaseSpec(dUid, CoolLentaManager.ALL_BLOCKS_DB_REF)).map(function(record) {
                var block = CoolLentaModelUtils.recordToBlock(record);
                return new CoolLentaBlockEvent(pUid, CoolLentaEventType.ALL_BLOCKS_UPDATE, block).withRevision(record.rev());
            });

            events = events.plus(dataApiManager.getRecords(new UserDatabaseSpec(dUid, CoolLentaManager.MORDA_BLOCKS_DB_REF)).map(function(record) {
                var block = CoolLentaModelUtils.recordToMordaBlock(record);
                return new CoolLentaBlockEvent(pUid, CoolLentaEventType.MORDA_BLOCKS_ADD, block).withRevision(record.rev());
            }))

            CoolLentaEventLogger.log(events);
            logger.info("Exported data for uid={}", rawUid)
            return
        } catch(e) {
            logger.warn("Retry export data for uid={} : {}", rawUid, e)
        }
    }
    logger.warn("Failed to export data for uid={} : {}", rawUid, e)
}

uids.forEach(function(uid) {
    var finalUid = uid
    executer.submit(new java.lang.Runnable(function() {logUidData(finalUid);}));
});

executer.shutdown();