importPackage(ru.yandex.inside.yt.kosher.cypress)
importPackage(ru.yandex.inside.yt.kosher.tables)
importPackage(ru.yandex.chemodan.app.lentaloader.cool.model)
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter.condition)
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter)
importPackage(ru.yandex.chemodan.app.dataapi.api.deltas)
importClass(ru.yandex.misc.log.mlf.LoggerFactory);
importClass(ru.yandex.chemodan.app.lentaloader.cool.CoolLentaManager)
importPackage(ru.yandex.chemodan.app.dataapi.api.db.ref)
importPackage(ru.yandex.inside.passport)
importPackage(ru.yandex.chemodan.app.dataapi.api.user)
importClass(ru.yandex.chemodan.app.lentaloader.cool.model.CoolLentaModelUtils)
importPackage(ru.yandex.chemodan.app.lentaloader.cool.log)
importClass(ru.yandex.chemodan.app.lentaloader.reminder.PhotoSelectionFields)

var part = 'part_1'
var logger = LoggerFactory.getLogger("experiment_checker_" + part);
var executer = java.util.concurrent.Executors.newFixedThreadPool(100, new ru.yandex.misc.thread.factory.ThreadNameIndexThreadFactory("experiment_checker_" + part));

function checkExperiment(uidS) {
    var uidO = Cf.Long.parseSafe(uidS + '');
    if (!uidO.isPresent()) {
        return
    }

    var uid = uidO.get()
    var flags = experimentsManager.getFlags(uid);

    flags.find(function(flag) {
        return flag.startsWith("disk_lenta_blocks_process_visit_blocks_per_day")
    }).forEach(function(flag) {
        logger.info('part={}, uid={}, flag={}', part, uid, flag);
    })
}

DB_REF = new AppDatabaseRef("lenta", "lenta_blocks");
base_path = YPath.simple("//home/disk-dev/tolmalev/mobile_uids_2019_10_21_" + part)

var step = 10000;
var size = ytClient.cypress().get(base_path.attribute("row_count")).longValue();

for (var i = 0; i < size; i += step) {
    var path = base_path.withRange(i, Math.min(i + step, size))

    nodes = Cf.arrayList()
    ytClient.tables().read(Option.none(), false, path, YTableEntryTypes.JACKSON, function(it) {
        while (it.hasNext()) {
            nodes.add(it.next())
        }
    })

    nodes.forEach(function(node) {
        var accountId = node.get("uid");
        if (!accountId) {
            return;
        }
        var finalUid = accountId.asText();

        executer.submit(new java.lang.Runnable(function() {
            checkExperiment(finalUid)
        }))
    })
}

executer.shutdown();