importPackage(ru.yandex.inside.yt.kosher.cypress)
importPackage(ru.yandex.inside.yt.kosher.tables)
importPackage(ru.yandex.chemodan.app.lentaloader.cool.model)
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter.condition)
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter)
importPackage(ru.yandex.chemodan.app.dataapi.api.deltas)
importClass(ru.yandex.misc.log.mlf.LoggerFactory);
importClass(ru.yandex.chemodan.app.lentaloader.cool.CoolLentaManager)
importPackage(ru.yandex.chemodan.app.dataapi.api.db.ref)
importPackage(ru.yandex.inside.passport)
importPackage(ru.yandex.chemodan.app.dataapi.api.user)
importClass(ru.yandex.chemodan.app.lentaloader.cool.model.CoolLentaModelUtils)
importPackage(ru.yandex.chemodan.app.lentaloader.cool.log)
importClass(ru.yandex.chemodan.app.lentaloader.reminder.PhotoSelectionFields)

var logger = LoggerFactory.getLogger("lenta-cleaner");
var executer = java.util.concurrent.Executors.newFixedThreadPool(100, new ru.yandex.misc.thread.factory.ThreadNameIndexThreadFactory("lenta-cleaner"));

var path = YPath.simple("//home/disk-dev/tolmalev/bad_blocks/09-01").withRange(0, 10)

DB_REF = new AppDatabaseRef("lenta", "lenta_blocks");

function fixBlock(uid, block_id) {
    logger.info("clearing object uid={}, block_id={}", uid, block_id)

    for(var i = 0; i < 5; i += 1) {
        try {
            var uid = new DataApiPassportUserId(Cf.Long.parse(uid + ""))
            var database = dataApiManager.getOrCreateDatabase(new UserDatabaseSpec(uid, DB_REF));

            var records = dataApiManager.getRecords(database.spec(), RecordsFilter.DEFAULT.withCollectionId("index").withRecordIdCond(RecordIdCondition.eq(block_id)));
            if (records.isEmpty()) {
                logger.info("record not found uid={}, block_id={}", uid, block_id)
                return
            }

            var record = records.first()
            var resourse_ids = PhotoSelectionFields.RESOURCE_IDS.get(record)
            var exists = Cf.hashSet();

            var new_record_ids = Cf.arrayList()
            for (var j = 0; j < resourse_ids.size(); j++) {
                var res_id = resourse_ids.get(j)
                if (!exists.contains(res_id)) {
                    new_record_ids.add(res_id)
                    exists.add(res_id)
                }
            }

            if (resourse_ids.size() == new_record_ids.size()) {
                logger.info('everything already cleaned, uid={}, block_id={}', uid, block_id)
                return
            }

            logger.info("was: {}, now: {}", resourse_ids.size(), new_record_ids.size())
            var change = RecordChange.update(record.getCollectionId(), record.getRecordId(), PhotoSelectionFields.RESOURCE_IDS.changedTo(new_record_ids))
            logger.info("saving delta {}", change)

            dataApiManager.applyDelta(database, RevisionCheckMode.PER_RECORD, new Delta(change));

            logger.info("cleared object uid={}, block_id={}", uid, block_id)
            return
        } catch(e) {
            logger.info("retry clearing object uid={}, block_id={}, {}", uid, block_id, e)
        }
    }
    logger.info("failed to fix object uid={}, block_id={}", uid, block_id)
}

nodes = Cf.arrayList()
ytClient.tables().read(Option.none(), false, path, YTableEntryTypes.JACKSON, function(it) {
    while(it.hasNext()) {
        nodes.add(it.next())
    }
})

nodes.forEach(function(node) {
    var finalUid = node.get("uid").asText()
    var finalBlockId = node.get("block_id").asText()

    executer.submit(new java.lang.Runnable(function() {
        fixBlock(finalUid, finalBlockId)
    }))
})

executer.shutdown();