importPackage(ru.yandex.chemodan.app.lentaloader.reminder);
importPackage(org.joda.time);
importPackage(ru.yandex.misc.random);
importPackage(ru.yandex.chemodan.app.dataapi.api.user);
importPackage(ru.yandex.chemodan.app.dataapi.api.db.ref);
importPackage(ru.yandex.chemodan.app.lentaloader.cool);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter.ordering);
importPackage(ru.yandex.chemodan.app.lentaloader.cool.model);
importPackage(ru.yandex.chemodan.app.dataapi.api.deltas);


var executer = java.util.concurrent.Executors.newFixedThreadPool(10, new ru.yandex.misc.thread.factory.ThreadNameIndexThreadFactory("thematic-blocks-generator"));

var testUids = experimentMembersByOverrideManager.getMembers('<experiment-flag>')//[800796570, 569679557, 582231869, 229876270, 19893712, 15560647, 165718274, 27298901, 69194959, 24855543, 28706646, 194836852, 275183509, 125623650, 100265970, 368260381, 472982803, 42175757, 60643505, 107157583, 122625849, 37963434, 320054257, 466199243, 445435569, 182959371, 335932448, 319363353, 206874748, 32665838, 37324586, 525040992, 2735332, 271843023, 159163326, 62096898, 208983871, 199919915, 8208673, 185083668, 322147061, 231839493, 381026824, 424380464, 428991000, 331894720, 31652443, 178892072, 805755342, 15147017, 369302972, 19042047, 576673125, 411558511, 858999690, 914060931, 9426447, 479333800, 227356512, 434144449, 76473638, 24970639, 31822652, 43103692, 12758712, 196447678, 26295841, 387259141, 130922572, 44902531, 202184824, 18374572, 255750228, 8836343, 207296633, 28285261, 164941365, 50273844];

var generateBlocks = function(uid) {
	coolLentaTasksScheduler.scheduleTasksForUserHighPriority(new ru.yandex.inside.passport.PassportUid(uid));
};

var sendBlocks = function(uid) { 
	Cf.range(0, 10).forEach(function() {
		coolLentaReminder.generateBlock(new ru.yandex.inside.passport.PassportUid(uid), DateTime.now());
	});
};

//var removeBlocks = function(uid) {
//	coolLentaManager.removeAllBlockForDebug(new ru.yandex.inside.passport.PassportUid(uid));
//}

var experimentalThemes = themeDefinitionRegistry.getAll().filter(function (theme) { return theme.isExperimentalForReminding() }).map(function(theme) { return theme.getName()})

var removeExperimentalBlocks = function(uid) {
	var puid = new ru.yandex.inside.passport.PassportUid(uid);
	var changes = Cf.arrayList();
	coolLentaManager.getAllBlocks(puid).filter(function (block) {return block.id.startsWith('thematic_') && experimentalThemes.exists(function(theme) {return block.id.endsWith('_' + theme)})}).forEach(function(block) {
         	changes.add(RecordChange.delete(CoolLentaManager.ALL_BLOCKS_COLLECTION_ID, block.id));
         });;
	if (changes.isEmpty()) {
		return;
	}
	var database = dataApiManager.getOrCreateDatabase(new UserDatabaseSpec(new DataApiPassportUserId(uid),
                CoolLentaManager.ALL_BLOCKS_DB_REF));
    dataApiManager.applyDelta(database, RevisionCheckMode.PER_RECORD, new Delta(changes));
}

var removeExperimentalBlocksAsync = function(uids) {
	var submittedTasks = Cf.arrayList();
    uids.forEach(function(uid) {
        var finalUid = uid
        submittedTasks.add(executer.submit(new java.lang.Runnable(function() { removeExperimentalBlocks(finalUid); })));
    });
    return submittedTasks;
}

var generateBlocksAsync = function(uids) {
    var submittedTasks = Cf.arrayList();
    uids.forEach(function(uid) {
        var finalUid = uid
        submittedTasks.add(executer.submit(new java.lang.Runnable(function() { generateBlocks(finalUid); })));
    });
    return submittedTasks;
}

//    var submittedTasks = Cf.arrayList();
  //  uids.forEach(function(uid) {
    //    var finalUid = uid
    //    submittedTasks.add(executer.submit(new java.lang.Runnable(function() { removeBlocks(finalUid); })));
   // });
    //return submittedTasks;
//}

var sendBlocksAsync = function(uids) {
    var submittedTasks = Cf.arrayList();
    uids.forEach(function(uid) {
        var finalUid = uid
        submittedTasks.add(executer.submit(new java.lang.Runnable(function() { sendBlocks(finalUid); })));
    });
    return submittedTasks;
}

var getTasksStatistics = function(tasks) {
	var stat = {};
	stat.count = tasks.size();
	stat.doneCount = tasks.filter(function(task) {
		return task.isDone();
	}).size();
	return stat.toSource();
}

var getThematicBlocksCounts = function(uids) {
	var result = Cf.hashMap();
	for (var i = 0; i < uids.size(); i++) {
		var uid = uids.get(i);
		result.put(uid, coolLentaManager.getAllBlocks(new ru.yandex.inside.passport.PassportUid(uid)).filter(function(block) {return block.getId().startsWith('thematic_')}).size());
	}
	return result;
};

var sendExperimentalBlocks = function(uid) { 
	Cf.range(0, 20).forEach(function() {
		coolLentaReminder.generateExperimentalThematicBlock(new ru.yandex.inside.passport.PassportUid(uid), DateTime.now());
	});
};

var sendExperimentalBlocksAsync = function(uids) {
	var submittedTasks = Cf.arrayList();
    uids.forEach(function(uid) {
        var finalUid = uid
        submittedTasks.add(executer.submit(new java.lang.Runnable(function() { sendExperimentalBlocks(finalUid); })));
    });
    return submittedTasks;
}

var submittedTasks = sendExperimentalBlocksAsync(testUids);

//testUids.forEach(function(uid) {
//    var finalUid = uid
//    submittedTasks.add(executer.submit(new java.lang.Runnable(function() {generateBlocks(finalUid);})));
//});

executer.shutdown();

var step = 1000;
var size = 10501;
var removeExperimentalBlocksTasks = Cf.arrayList();

for (var i = 0; i < size; i += step) {
    var path = YPath.simple("//home/disk-dev/messiahlap/thematic/uids_with_experimental/2019-10-21").withRange(i, Math.min(i + step, size))

    nodes = Cf.arrayList()
    ytClient.tables().read(Option.none(), false, path, YTableEntryTypes.JACKSON, function(it) {
        while (it.hasNext()) {
            nodes.add(it.next())
        }
    })

    nodes.forEach(function(node) {
        var uid = node.get("uid");
        if (!uid) {
            return;
        }
        var finalUid = java.lang.Long.parseLong(uid.asText());

        removeExperimentalBlocksTasks.add(executer.submit(new java.lang.Runnable(function() {
            removeExperimentalBlocks(finalUid)
        })))
    })
}
executer.shutdown();
