importClass(ru.yandex.misc.log.mlf.LoggerFactory);

var logger = LoggerFactory.getLogger("cool-lenta-check");

shards = Cf.list(dataShardManager.shards());

function zeroPad(num, places) {
    var zero = places - num.toString().length + 1;
    return Array(+(zero > 0 && zero)).join("0") + num;
}

users = 0
good_blocks = 0;
bad_blocks = 0;

users_with_bad = 0;

for (var j = 0; j < shards.size(); j++) {
    template = shards.get(j).getJdbcTemplate3();
    for (var i = 0; i < 128; i++) {
        part_users = template.queryForList("Select distinct(user_id) from databases_" + zeroPad(i, 3) + " WHERE app='cool_lenta'", java.lang.Class.forName("java.lang.String"));

        for (var k = 0; k < part_users.size(); k++) {
            uid = ru.yandex.inside.passport.PassportUid.cons(Cf.Long.parse(part_users.get(k)))
            blocks = coolLentaManager.getRandomBlocks(uid, 100500);
            hasBad = false;
            for (var t = 0; t < blocks.size(); t++) {
                if (coolLentaManager.checkBlockFilesInMpfs(uid, blocks.get(t))) {bad_blocks += 1; hasBad=true;} else {good_blocks += 1}
            }
            if (hasBad) {users_with_bad += 1;}
        }
        users += part_users.size()
        logger.info("users={}, users_with_bad = {}, users_with_bad_percent={}", users, users_with_bad, (users - users_with_bad) * 100.0 / users)
        logger.info("good_blocks={}, bad_blocks={}, good_blocks_percent={}", good_blocks, bad_blocks, good_blocks * 100.0 / (bad_blocks + good_blocks))
    }
}