importClass(ru.yandex.misc.log.mlf.LoggerFactory);
importClass(ru.yandex.chemodan.app.dataapi.api.db.DatabaseDeletionMode)
importClass(ru.yandex.chemodan.app.dataapi.api.db.ref.UserDatabaseSpec)
importClass(ru.yandex.chemodan.app.dataapi.api.user.DataApiPassportUserId)
importClass(ru.yandex.chemodan.app.dataapi.api.db.ref.AppDatabaseRef)

yandexUids = (new File2("/tmp/yandex_uids")).readLines().flatMap(function(x){return Cf.Long.parseSafe(x)}).map(function(x){return x.toString()}).unique();

var logger = LoggerFactory.getLogger("cool-lenta-dropper");
var executer = java.util.concurrent.Executors.newFixedThreadPool(10, new ru.yandex.misc.thread.factory.ThreadNameIndexThreadFactory("cool-lenta-dropper"));

shards = Cf.list(dataShardManager.shards());
ALL_BLOCKS_DB_REF = new AppDatabaseRef("cool_lenta", "all_blocks");
MORDA_BLOCKS_DB_REF = new AppDatabaseRef("cool_lenta", "morda_blocks");

function zeroPad(num, places) {
    var zero = places - num.toString().length + 1;
    return Array(+(zero > 0 && zero)).join("0") + num;
}

function drop_data_for_user_with_retries(uidStr) {
    // ignore yandex uids
    if (yandexUids.containsTs(uidStr + "")) {
        logger.info("Skip yandex uid={}", uidStr)
        return true;
    }

    var uid = ru.yandex.inside.passport.PassportUid.cons(Cf.Long.parse("" + uidStr));

    var deleted = false
    for (var w = 0; w < 5; w += 1) {
        try {
            dataApiManager.deleteDatabaseIfExists(new UserDatabaseSpec(new DataApiPassportUserId(uid), ALL_BLOCKS_DB_REF),
                            DatabaseDeletionMode.REMOVE_COMPLETELY);

            dataApiManager.deleteDatabaseIfExists(new UserDatabaseSpec(new DataApiPassportUserId(uid), MORDA_BLOCKS_DB_REF),
                            DatabaseDeletionMode.REMOVE_COMPLETELY);
            logger.info("Deleted all data for uid={}", uid)
            deleted = true
            break;
        } catch (e) {
            logger.warn("Retry delete data for uid={} : {}", uidStr, e);
        }
    }
    return deleted
}

function drop_for_shard_and_partition(shard, partition) {
    logger.info("Cleaning data from shard={}, partition={}", shard, partition)
    var template = shard.getJdbcTemplate3();
    try {
        var part_users = template.queryForList("Select distinct(user_id) from databases_" + zeroPad(partition, 3) + " WHERE app='cool_lenta'", java.lang.Class.forName("java.lang.String"));
    } catch(e) {
        logger.error("Failed to get users: {}", e)
    }
    logger.info("Found users to clean: {}", part_users.size())
    var failed_users = Cf.arrayList()

    for (var k = 0; k < part_users.size(); k++) {
        var uid = part_users.get(k)

        if (!drop_data_for_user_with_retries(uid)) {
            failed_users.add(uid)
        }
    }
    for (var w = 0; w < failed_users.size(); w += 1) {
        logger.error("Failed to delete data for uid={}", failed_users.get(w))
    }
    logger.info("Finish clearing data from shard={}, partition={}", shard, partition)
}

for (var i = 0; i < 128; i++) {
    for (var j = 0; j < shards.size(); j++) {
        var shardP = shards.get(j);
        var partitionP = i;
        executer.submit(new java.lang.Runnable(function() {
            drop_for_shard_and_partition(shardP, partitionP);
        }));
    }
}

executer.shutdown();