importPackage(ru.yandex.inside.yt.kosher.cypress)
importPackage(ru.yandex.inside.yt.kosher.tables)
importPackage(ru.yandex.chemodan.app.lentaloader.cool.model)
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter.condition)
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter)
importPackage(ru.yandex.chemodan.app.dataapi.api.deltas)
importClass(ru.yandex.misc.log.mlf.LoggerFactory);
importClass(ru.yandex.chemodan.app.lentaloader.cool.CoolLentaManager)
importPackage(ru.yandex.chemodan.app.dataapi.api.db.ref)
importPackage(ru.yandex.inside.passport)
importPackage(ru.yandex.chemodan.app.dataapi.api.user)
importClass(ru.yandex.chemodan.app.lentaloader.cool.model.CoolLentaModelUtils)
importPackage(ru.yandex.chemodan.app.lentaloader.cool.log)

var logger = LoggerFactory.getLogger("lenta-cleaner");
var executer = java.util.concurrent.Executors.newFixedThreadPool(100, new ru.yandex.misc.thread.factory.ThreadNameIndexThreadFactory("lenta-cleaner"));
var path = YPath.simple("//tmp/tolmalev/29962b32-a81a38c4-806eb69d-bf1a30ef").withRange(0, 10000)

function removeLegacy(uid, collection, block_id) {
    if (collection != 'all_blocks') {
        return
    }

    logger.info("clearing object uid={}, block_id={}", uid, block_id)

    for(var i = 0; i < 5; i += 1) {
        try {
            var uid = new DataApiPassportUserId(Cf.Long.parse(uid + ""))
            var database = dataApiManager.getOrCreateDatabase(new UserDatabaseSpec(uid, CoolLentaManager.ALL_BLOCKS_DB_REF));

            var records = dataApiManager.getRecords(database.spec(), RecordsFilter.DEFAULT.withCollectionId("all_blocks").withRecordIdCond(RecordIdCondition.eq(block_id)));
            if (records.isEmpty()) {
                logger.info("record not found uid={}, block_id={}", uid, block_id)
                return
            }

            if (CoolLentaBlockFields.LEGACY_LENTA_LAST_SHOW_DATE.getO(records.first()).isEmpty()) {
                logger.info("record has no field legacy_lenta_last_show_date found uid={}, block_id={}", uid, block_id)
                return
            }

            var change = RecordChange.update(CoolLentaManager.ALL_BLOCKS_COLLECTION_ID, block_id, FieldChange.delete('legacy_lenta_last_show_date'))
            dataApiManager.applyDelta(database, RevisionCheckMode.PER_RECORD, new Delta(change));
            logger.info("cleared object uid={}, block_id={}", uid, block_id)
            return
        } catch(e) {
            logger.info("retry clearing object uid={}, block_id={}", uid, block_id)
        }
    }
    logger.info("failed to clear object uid={}, block_id={}", uid, block_id)
}

removeLegacy("269884138", "all_blocks", "default_month_1030824000000")

nodes = Cf.arrayList()

ytClient.tables().read(Option.none(), false, path, YTableEntryTypes.JACKSON, function(it) {
    while(it.hasNext()) {
        nodes.add(it.next())
    }
})

nodes.forEach(function(node) {
    var finalUid = node.get("uid").asText()
    var finalBlockCollection = node.get("block_collection").asText()
    var finalBlockId = node.get("block_id").asText()
    executer.submit(new java.lang.Runnable(function() {
        removeLegacy(finalUid, finalBlockCollection, finalBlockId)
    }))
})

executer.shutdown();