importPackage(ru.yandex.inside.yt.kosher.cypress)
importPackage(ru.yandex.inside.yt.kosher.tables)
importPackage(ru.yandex.chemodan.app.lentaloader.cool.model)
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter.condition)
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter)
importPackage(ru.yandex.chemodan.app.dataapi.api.deltas)
importClass(ru.yandex.misc.log.mlf.LoggerFactory);
importClass(ru.yandex.chemodan.app.lentaloader.cool.CoolLentaManager)
importPackage(ru.yandex.chemodan.app.dataapi.api.db.ref)
importPackage(ru.yandex.inside.passport)
importPackage(ru.yandex.chemodan.app.dataapi.api.user)
importClass(ru.yandex.chemodan.app.lentaloader.cool.model.CoolLentaModelUtils)
importPackage(ru.yandex.chemodan.app.lentaloader.cool.log)

var uid = new DataApiPassportUserId(27298901)

var database = dataApiManager.getOrCreateDatabase(new UserDatabaseSpec(uid, CoolLentaManager.ALL_BLOCKS_DB_REF));

var changes = coolLentaManager.getAllBlocks(uid).filter(function(block) {
        return block.legacyLentaLastShowDate.isPresent()
    }).map(function(block) {
        return RecordChange.update(CoolLentaManager.ALL_BLOCKS_COLLECTION_ID, block.id, FieldChange.delete('legacy_lenta_last_show_date'))
    })

if (changes.isNotEmpty()) {
    dataApiManager.applyDelta(database, RevisionCheckMode.PER_RECORD, new Delta(change));
}