importClass(org.joda.time.LocalDate);
importClass(ru.yandex.inside.yt.kosher.cypress.YPath);
importClass(ru.yandex.chemodan.app.lentaloader.YtPathsUtils);


var yt = coolLentaYtHelper;
var dateToCollectData = new LocalDate(2020, 07, 14);
var sourceDataPath = YPath.simple("//logs/ydisk-lenta-cool-events-log/1d/" + dateToCollectData);
var outputFolderDataPath = YtPathsUtils.getCoolLentaUserWithBlocksYPath();
var lastAvailableOutputDataPath = outputFolderDataPath.child(dateToCollectData.minusDays(1).toString());
var currentOutputDataPath = outputFolderDataPath.child(dateToCollectData.toString());
yt.waitForTableForMinutes(sourceDataPath, 5);
var yql =
        "PRAGMA yt.DefaultOperationWeight=\"50.0\";\n" +
                    "USE hahn;\n" +
                    "\n" +
                    "INSERT INTO {{output_path}}\n" +
                    "SELECT DISTINCT uid FROM (\n" +
                    "   SELECT uid FROM {{logInputPath}} WHERE event_type IN ('all-blocks-create', 'all-blocks-update')\n" +
                    "   UNION ALL\n" +
                    "   SELECT uid FROM {{prevTableInputPath}}\n" +
                    ")";

yql = yql
        .replace("{{logInputPath}}", "`" + sourceDataPath + "`")
        .replace("{{prevTableInputPath}}", "`" + lastAvailableOutputDataPath + "`")
        .replace("{{output_path}}", "`" + currentOutputDataPath + "`");

// Если таблица уже есть - незачем заново ее генерировать
if (!yt.existsWithRetries(currentOutputDataPath)) {
    yqlHelper.execute(yql);
}