importPackage(ru.yandex.chemodan.app.dataapi.api.user)
importPackage(ru.yandex.chemodan.app.dataapi.api.db.ref)
importPackage(ru.yandex.chemodan.app.dataapi.api.db)
importPackage(ru.yandex.inside.passport)
importPackage(ru.yandex.chemodan.app.lentaloader.cool)
importPackage(ru.yandex.misc.io.http)
importClass(ru.yandex.misc.lang.Check)
importClass(ru.yandex.misc.thread.ThreadUtils)

clearExisting = false
log = ru.yandex.misc.log.mlf.LoggerFactory.getLogger("cool-lenta-scheduler")
var executer = java.util.concurrent.Executors.newFixedThreadPool(50, new ru.yandex.misc.thread.factory.ThreadNameIndexThreadFactory("cool-lenta-scheduler"));

var uids = (new File2("/tmp/uids_to_schedule")).readLines().flatMap(function(x){return Cf.Long.parseSafe(x)});

function scheduleForUid(uidL) {
    if (clearExisting) {
        dataApiManager.deleteDatabaseIfExists(new UserDatabaseSpec(new DataApiPassportUserId(uidL), CoolLentaManager.ALL_BLOCKS_DB_REF),
                    DatabaseDeletionMode.REMOVE_COMPLETELY);

        dataApiManager.deleteDatabaseIfExists(new UserDatabaseSpec(new DataApiPassportUserId(uidL), CoolLentaManager.MORDA_BLOCKS_DB_REF),
                    DatabaseDeletionMode.REMOVE_COMPLETELY);
    }
    var submitted = false
    for(var w = 0; w < 5; w++) {
        try {
            coolLentaTasksScheduler.scheduleTasksForUser(new PassportUid(uidL))
            log.info("submited tasks for " + uidL)
            submitted = true
            break;
        } catch(e) {
            log.warn("Retry submit tasks for " + uidL + ": {}", e)
            ThreadUtils.sleep(5000)
        }
    }
    if (!submitted) {
        log.error("Failed to submit task for uid={}", uidL)
    }
}
print(uids.size())

for (var i = 0; i < uids.size(); i++) {
    var finalUid = uids.get(i)
    executer.submit(new java.lang.Runnable(function() {scheduleForUid(finalUid);}));
}

executer.shutdown();