importPackage(ru.yandex.inside.yt.kosher.cypress);
importPackage(ru.yandex.inside.yt.kosher.tables);
importPackage(ru.yandex.chemodan.app.lentaloader.cool.model);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter.condition);
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter);
importPackage(ru.yandex.chemodan.app.dataapi.api.deltas);
importClass(ru.yandex.misc.log.mlf.LoggerFactory);
importPackage(ru.yandex.chemodan.app.dataapi.api.db.ref);
importPackage(ru.yandex.inside.passport);
importPackage(ru.yandex.chemodan.app.dataapi.api.user);
importClass(ru.yandex.chemodan.app.lentaloader.cool.model.CoolLentaModelUtils);
importPackage(ru.yandex.chemodan.app.lentaloader.cool.log);

var logger = LoggerFactory.getLogger("lenta-last-push-date");
var executer = java.util.concurrent.Executors.newFixedThreadPool(100, new ru.yandex.misc.thread.factory.ThreadNameIndexThreadFactory("lenta-last-push-date"));

function addLastPushDate(rawUid) {
    logger.info("checking blocks for uid={}", rawUid)

    for (var i = 0; i < 5; i += 1) {
        try {
            var uid = new DataApiPassportUserId(Cf.Long.parse(rawUid + ""))
            var database = dataApiManager.getOrCreateDatabase(new UserDatabaseSpec(uid, DB_REF));

            var records = dataApiManager.getRecords(database.spec()).filter(function(record) {
                return CoolLentaBlockFields.LEGACY_LENTA_LAST_SHOW_DATE.getO(record).isPresent();
            });
            if (records.isEmpty()) {
                logger.info("records not found uid={}", uid)
                return
            }

            var changes = Cf.arrayList();
            records.forEach(function(record) {
                var lastSendDate = CoolLentaBlockFields.LEGACY_LENTA_LAST_SHOW_DATE.get(record);
                if (!CoolLentaBlockFields.LEGACY_LENTA_LAST_PUSH_DATE.getO(record).isPresent()) {
                    changes.add(RecordChange.update(record.getCollectionId(), record.getRecordId(), CoolLentaBlockFields.LEGACY_LENTA_LAST_PUSH_DATE.changedTo(lastSendDate)));
                }
            });

            logger.info("saving delta {}", changes)

            dataApiManager.applyDelta(database, RevisionCheckMode.PER_RECORD, new Delta(changes));

            logger.info("updated blocks uid={} blocks_count={}", uid, records.size());
            return;
        } catch (e) {
            logger.info("retry updating collection uid={}, {}", uid, e)
            java.lang.Thread.sleep(50);
        }
    }
    logger.info("failed to update blocks uid={}", uid)
};

DB_REF = new AppDatabaseRef("cool_lenta", "all_blocks");

var step = 10000;
var size = 3191595;

for (var i = 0; i < size; i += step) {
    var path = YPath.simple("//home/disk-dev/messiahlap/update_push_dates/sent_blocks_week_till_09-12").withRange(i, Math.min(i + step, size))

    nodes = Cf.arrayList()
    ytClient.tables().read(Option.none(), false, path, YTableEntryTypes.JACKSON, function(it) {
        while (it.hasNext()) {
            nodes.add(it.next())
        }
    })

    nodes.forEach(function(node) {
        var finalUid = node.get("uid").asText()

        executer.submit(new java.lang.Runnable(function() {
            addLastPushDate(finalUid)
        }))
    })
}

executer.shutdown();