importClass(ru.yandex.misc.bender.Bender)
importClass(ru.yandex.chemodan.mpfs.MpfsUser)
importClass(ru.yandex.inside.yt.kosher.tables.types.BenderTableEntryType)
importClass(ru.yandex.inside.yt.kosher.cypress.YPath)
importClass(ru.yandex.chemodan.app.lentaloader.reminder.DiskSearchFileInfo)
importClass(ru.yandex.inside.yt.kosher.tables.YTableEntryTypes)
importClass(ru.yandex.inside.passport.PassportUid)
importClass(ru.yandex.misc.time.InstantInterval)

uidL = 50273844
ndays = 40

uid = MpfsUser.of(uidL)

interval = new InstantInterval(Instant.now().minus(Duration.standardDays(ndays)), Instant.now())
resp = diskSearchClient.findPhotosWithBeauty(PassportUid.cons(uidL), interval, Option.empty(), 0, 100000)

print(resp.hitsArray.size())
sorted = resp.hitsArray.filter(function(x) {return x.beautiful2.isPresent()}).sortedByDesc(function(x) {return x.beautiful2.get()})
print(sorted.size())

allResourceIds = sorted.map(function(x){return uidL + ":" + x.id})

allFileInfos = Cf.hashMap()
allResourceIds.paginate(50).forEach(function(part) {
    infos = mpfsClient.bulkInfoByResourceIds(uid, part, Cf.list("/disk", "/photounlim"))
    allFileInfos.putAll(infos.toMapMappingToKey(function(i) {return i.meta.resourceId.get().toString() }))
})

function getPreviewUrl(id) {
    resId = uidL + ":" + id
    infoO = allFileInfos.getO(resId)

    return infoO.flatMapO(function(r) {return r.meta.preview })
}

cols = 8
sb = new java.lang.StringBuilder()
sb.append("<table>")
o = 0
for (var i = 0; i < sorted.size(); i++) {
        if (o % cols == 0) {
            sb.append("<tr>")
        }
        item = sorted.get(i)
        beauty = item.getBeautiful2()
        id = item.id

        preview = getPreviewUrl(id)
        if (preview.isPresent()) {
            sb.append("<td>")
            sb.append(beauty + "<br/>")
            sb.append("<img src=\"" + preview.get() + "\"/>")
            sb.append("</td>")
            o++
        }
        if (o % cols == 0) {
            sb.append("</tr>")
        }
}
if (!(o % cols == 0)) {
    sb.append("</tr>")
}
sb.append("</table>")

f = new File2("/tmp/top.html")
f.write(sb.toString())
print(sb.toString())