importPackage(ru.yandex.inside.yt.kosher.cypress)
importPackage(ru.yandex.inside.yt.kosher.tables)
importPackage(ru.yandex.chemodan.app.lentaloader.cool.model)
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter.condition)
importPackage(ru.yandex.chemodan.app.dataapi.api.data.filter)
importPackage(ru.yandex.chemodan.app.dataapi.api.deltas)
importClass(ru.yandex.misc.log.mlf.LoggerFactory);
importClass(ru.yandex.chemodan.app.lentaloader.cool.CoolLentaManager)
importPackage(ru.yandex.inside.passport)
importPackage(ru.yandex.chemodan.app.lentaloader.cool.log)

var logger = LoggerFactory.getLogger("lenta-thematic-stat");
var executer = java.util.concurrent.Executors.newFixedThreadPool(100, new ru.yandex.misc.thread.factory.ThreadNameIndexThreadFactory("lenta-thematic-stat"));
var statistics = new java.util.concurrent.ConcurrentHashMap();

function addStatistics(uid) {
    uid = Cf.Long.parse(uid + '');
    var allBlocks = coolLentaManager.getAllBlocks(new PassportUid(uid));
    var userStatistics = Cf.hashMap();
    var thematicBlocks = allBlocks.filter(function(block) {
        return block.getId().startsWith('thematic_');
    });
    if (allBlocks.size() === thematicBlocks.size()) {
        return;
    }
    userStatistics.put('non_thematic_blocks', allBlocks.size() - thematicBlocks.size());
    userStatistics.put('thematic_blocks', thematicBlocks.size());
    var increaseRate = thematicBlocks.size() / (allBlocks.size() - thematicBlocks.size());
    userStatistics.put('increase_rate', increaseRate);
    statistics.put(uid, userStatistics);
}

var step = 100;
var size = 10000;

for (var i = 0; i < size; i += step) {
    var path = YPath.simple("//home/mpfs-stat/cool-lenta/reindex-queue").withRange(i, Math.min(i + step, size))

    nodes = Cf.arrayList()
    ytClient.tables().read(Option.none(), false, path, YTableEntryTypes.JACKSON, function(it) {
        while (it.hasNext()) {
            nodes.add(it.next())
        }
    })

    nodes.forEach(function(node) {
        var accountId = node.get("uid");
        if (!accountId) {
            return;
        }
        var finalUid = accountId.asText();
        executer.submit(new java.lang.Runnable(function() {
            addStatistics(finalUid)
        }))
    })
}
executer.shutdown();

var result = Cf.hashMap(Cf.map('non_thematic_blocks', 0, 'thematic_blocks', 0, 'increase_rate', 0));
Cf.x(statistics.values()).forEach(function(userStatistics) {
    result.put('non_thematic_blocks', result.get('non_thematic_blocks') + userStatistics.get('non_thematic_blocks'));
    result.put('thematic_blocks', result.get('thematic_blocks') + userStatistics.get('thematic_blocks'));
    result.put('increase_rate', result.get('increase_rate') + userStatistics.get('increase_rate'));
});

result.mapValues(function(value) {
    return value / statistics.size();
})

//{non_thematic_blocks=60.7589156626506, thematic_blocks=6.4724096385542165, increase_rate=0.07246994824357482}
//{non_thematic_blocks=72.08023880597015, thematic_blocks=6.589611940298507, increase_rate=0.06567546754046397}



