importPackage(ru.yandex.chemodan.app.lentaloader.cool.generator);
importPackage(ru.yandex.chemodan.app.lentaloader.cool.utils);
importPackage(ru.yandex.inside.utils);
importPackage(ru.yandex.bolts.collection);

var russianTD = new TermLanguageDefinition("природа", "природы", "о", "природе", "природой", "природу", "на природу", Option.empty());
var turkishTD = new TermLanguageDefinition("tabiat", "doğa", "doğa", "hakkında", "doğa", "doğa", "doğa", Option.empty());
var englishTD = new TermLanguageDefinition("nature", "of nature", "of", "nature", "nature", "nature", "to nature", Option.empty());
var ukranianTD = new TermLanguageDefinition("природа", "природи", "про", "природу", "природою", "природу", "на природу", Option.empty());
var natureWords = Cf.list(new WordMatch("природа", 3808), new WordMatch("nature", 4244));
var natureTheme = new ThemeDefinition("nature", natureWords,
                new TermDefinition(Cf.map(Language.RUSSIAN, russianTD,
                        Language.TURKISH, turkishTD,
                        Language.ENGLISH, englishTD,
                        Language.UKRAINIAN, ukranianTD)), true, Option.of(false), Option.of(false), Option.of(false), Option.empty());
themeDefinitionRegistry.put(natureTheme);

russianTD = new TermLanguageDefinition("горы", "гор", "о", "горах", "горами", "горы", "в горы", Option.empty());
turkishTD = new TermLanguageDefinition("dağ", "dağlar", "dağlar", "hakkında", "dağ", "dağ", "dağ", Option.empty());
englishTD = new TermLanguageDefinition("mountains", "of mountains", "of", "mountains","mountains", "mountains", " to mountains", Option.empty());
ukranianTD = new TermLanguageDefinition("гори", "гір", "про", "гори", "горами", "гори", "у гори", Option.empty());
var mountainsWords = Cf.list(new WordMatch("горы", 5238), new WordMatch("mountain", 5173), new WordMatch("mountains", 5114), new WordMatch("гора", 5769), new WordMatch("горный", 5235));
var mountainsTheme = new ThemeDefinition("mountains", mountainsWords,
                new TermDefinition(Cf.map(Language.RUSSIAN, russianTD,
                        Language.TURKISH, turkishTD,
                        Language.ENGLISH, englishTD,
                        Language.UKRAINIAN, ukranianTD)), true, Option.of(false), Option.of(false), Option.of(false), Option.empty());
themeDefinitionRegistry.put(mountainsTheme);

russianTD = new TermLanguageDefinition("море", "моря", "о", "море", " морем", "море", "к морю", Option.empty());
turkishTD = new TermLanguageDefinition("deniz", "denizle", "denizle", "hakkında", "deniz", "deniz", "deniz", Option.empty());
englishTD = new TermLanguageDefinition("the sea", "of the sea", "of", "the sea", "the sea", "the sea", "to the sea", Option.empty());
ukranianTD = new TermLanguageDefinition("море", "моря", "про", "море", "морем", "море", "до моря", Option.empty());
var seaWords = Cf.list(new WordMatch("море", 6914), new WordMatch("sea", 5543), new WordMatch("морской", 5402), new WordMatch("морской берег", 6398), new WordMatch("sea side", 6806));
var seaTheme = new ThemeDefinition("sea", seaWords,
                new TermDefinition(Cf.map(Language.RUSSIAN, russianTD,
                        Language.TURKISH, turkishTD,
                        Language.ENGLISH, englishTD,
                        Language.UKRAINIAN, ukranianTD)), true, Option.of(false), Option.of(false), Option.of(false), Option.empty());
themeDefinitionRegistry.put(seaTheme);

russianTD = new TermLanguageDefinition("облака", "облаков", "об", "облаках", "облаками", "облака", "в облака", Option.of("небо и облака"));
turkishTD = new TermLanguageDefinition("bulut", "bulutlar", "bulutlar", "hakkında", "bulut", "bulut", "bulut", Option.of("Gökyüzü ve bulut"));
englishTD = new TermLanguageDefinition("clouds", "of clouds", "of", "clouds", "clouds", "clouds", "to clouds", Option.of("the sky and clouds"));
ukranianTD = new TermLanguageDefinition("хмари", "хмар", "про", "хмари", "хмарами", "хмари", "у хмари", Option.of("небо і хмари"));
var cloudsWords = Cf.list(new WordMatch("облака", 4128), new WordMatch("облако", 5103), new WordMatch("cloud", 5407), new WordMatch("clouds", 5761));
var cloudsTheme = new ThemeDefinition("clouds", cloudsWords,
                new TermDefinition(Cf.map(Language.RUSSIAN, russianTD,
                        Language.TURKISH, turkishTD,
                        Language.ENGLISH, englishTD,
                        Language.UKRAINIAN, ukranianTD)), true, Option.of(false), Option.of(false), Option.of(false), Option.empty());
themeDefinitionRegistry.put(cloudsTheme);

russianTD = new TermLanguageDefinition("котики", "котиков", "о", "котиках", "котиками", "котиков", "к котикам", Option.empty());
turkishTD = new TermLanguageDefinition("kedi", "kediler", "kediler", "hakkında", "kedi", "kedi", "kedi", Option.empty());
englishTD = new TermLanguageDefinition("cats", "of cats", "of", "cats", "cats", "cats", "to cats", Option.empty());
ukranianTD = new TermLanguageDefinition("котики", "котиків", "про", "котиків", "котиками", "котиків", "до котиків", Option.empty());
var catsWords = Cf.list(new WordMatch("кошка", 5128), new WordMatch("котенок", 4981), new WordMatch("коты", 5692), new WordMatch("котик", 5072), new WordMatch("котики", 5421), new WordMatch("кот", 5532));
var catsTheme = new ThemeDefinition("cats", catsWords,
                new TermDefinition(Cf.map(Language.RUSSIAN, russianTD,
                        Language.TURKISH, turkishTD,
                        Language.ENGLISH, englishTD,
                        Language.UKRAINIAN, ukranianTD)), true, Option.of(false), Option.of(false), Option.of(false), Option.empty());
themeDefinitionRegistry.put(catsTheme);

russianTD = new TermLanguageDefinition("цветы", "цветов", "о", "цветах", "цветами", "цветы", "к цветам", Option.empty());
turkishTD = new TermLanguageDefinition("çiçek", "çiçekler", "çiçekler", "hakkında", "çiçek", "çiçek", "çiçek", Option.empty());
englishTD = new TermLanguageDefinition("flowers", "of flowers", "of", "flowers", "flowers", "flowers", "to flowers", Option.empty());
ukranianTD = new TermLanguageDefinition("квіти", "квітів", "про", "квіти", "квітами", "квіти", "до квітів", Option.empty());
var flowersWords = Cf.list(new WordMatch("цветы", 3147), new WordMatch("flower", 4261));
var flowersTheme = new ThemeDefinition("flowers", flowersWords,
                new TermDefinition(Cf.map(Language.RUSSIAN, russianTD,
                        Language.TURKISH, turkishTD,
                        Language.ENGLISH, englishTD,
                        Language.UKRAINIAN, ukranianTD)), true, Option.of(false), Option.of(false), Option.of(false), Option.empty());
themeDefinitionRegistry.put(flowersTheme);

var russianTD = new TermLanguageDefinition("собаки", "собак", "о", "собаках", "собаками", "собак", "к собакам", Option.empty());
var turkishTD = new TermLanguageDefinition("köpekler", "köpeklerin", "", "köpekleri", "köpeklere", "köpeklerde", "köpeklerden", Option.empty());
var englishTD = new TermLanguageDefinition("dogs", "of dogs", "of", "dogs", "dogs", "dogs", "to dogs", Option.empty());
var ukranianTD = new TermLanguageDefinition("собаки", "собак", "про", "собак", "собаками", "собак", "до собак", Option.empty());
var dogsWords = Cf.list(new WordMatch("собака", 5016), new WordMatch("dog", 6025));
var dogsTheme = new ThemeDefinition("dogs", dogsWords,
                new TermDefinition(Cf.map(Language.RUSSIAN, russianTD,
                        Language.TURKISH, turkishTD,
                        Language.ENGLISH, englishTD,
                        Language.UKRAINIAN, ukranianTD)), true, Option.of(false), Option.of(false), Option.of(false), Option.empty());
themeDefinitionRegistry.put(dogsTheme);

russianTD = new TermLanguageDefinition("салют", "салюта", "о", "салюте", "салютом", "салют", "к салюту", Option.empty());
turkishTD = new TermLanguageDefinition("havai fişekler", "havai fişeklerin", "havai", "fişekleri", "havai fişeklere", "havai fişeklerde", "havai fişeklerden", Option.empty());
englishTD = new TermLanguageDefinition("fireworks", "of fireworks", "of", "fireworks", "fireworks", "fireworks", "to fireworks", Option.empty());
ukranianTD = new TermLanguageDefinition("салют", "салюту", "про", "салют", "салютом", "салют", "до салюту", Option.empty());
var fireworksWords = Cf.list(new WordMatch("салют", 7840));
var fireworksTheme = new ThemeDefinition("firework", fireworksWords,
                new TermDefinition(Cf.map(Language.RUSSIAN, russianTD,
                        Language.TURKISH, turkishTD,
                        Language.ENGLISH, englishTD,
                        Language.UKRAINIAN, ukranianTD)), true, Option.of(false), Option.of(false), Option.of(false), Option.empty());
themeDefinitionRegistry.put(fireworksTheme);

russianTD = new TermLanguageDefinition("дорога", "дороги", "о", "дороге", "дорогой", "дорогу", "на дорогу", Option.empty());
turkishTD = new TermLanguageDefinition("yol", "yolun", "", "yolu", "yola", "yolda", "yoldan", Option.empty());
englishTD = new TermLanguageDefinition("roads", "of roads", "of", "roads", "roads", "roads", "to roads", Option.empty());
ukranianTD = new TermLanguageDefinition("дорога", "дороги", "про", "дорогу", "дорогою", "дорогу", "на дорогу", Option.empty());
var roadWords = Cf.list(new WordMatch("дорога", 5411), new WordMatch("road", 5588));
var roadTheme = new ThemeDefinition("road", roadWords,
                new TermDefinition(Cf.map(Language.RUSSIAN, russianTD,
                        Language.TURKISH, turkishTD,
                        Language.ENGLISH, englishTD,
                        Language.UKRAINIAN, ukranianTD)), true, Option.of(false), Option.of(false), Option.of(false), Option.empty());
themeDefinitionRegistry.put(roadTheme);

russianTD = new TermLanguageDefinition("встречи", "людей", "о", "людях", "людьми", "людей", "к людям", Option.empty());
turkishTD = new TermLanguageDefinition("buluşmalar", "insanların", "", "insanları", "insanlara", "insanlarda", "insanlardan", Option.empty());
englishTD = new TermLanguageDefinition("get-togethers", "of people", "of", "people", "people", "people", "to people", Option.empty());
ukranianTD = new TermLanguageDefinition("зустрічі", "людей", "про", "людей", "людьми", "людей", "до людей", Option.empty());
var peopleWords = Cf.list(new WordMatch("люди на фото", 4559), new WordMatch("групповые фото", 4226), new WordMatch("фото с людьми", 5100));
var peopleTheme = new ThemeDefinition("people", peopleWords,
                new TermDefinition(Cf.map(Language.RUSSIAN, russianTD,
                        Language.TURKISH, turkishTD,
                        Language.ENGLISH, englishTD,
                        Language.UKRAINIAN, ukranianTD)), true, Option.of(false), Option.of(true), Option.of(false), Option.of(1.0));
themeDefinitionRegistry.put(peopleTheme);

russianTD = new TermLanguageDefinition("дети", "детей", "о", "детях", "детьми", "детей", "к детям", Option.empty());
turkishTD = new TermLanguageDefinition("çocuklar", "çocukların", "", "çocukları", "çocuklara", "çocuklarda", "çocuklardan", Option.empty());
englishTD = new TermLanguageDefinition("kids", "of kids", "of", "kids", "kids", "kids", "to kids", Option.empty());
ukranianTD = new TermLanguageDefinition("діти", "дітей", "про", "дітей", "дітьми", "дітей", "до дітей", Option.empty());
var childrenWords = Cf.list(new WordMatch("дети", 5686), new WordMatch("ребенок", 5108), new WordMatch("children", 6549));
var childrenTheme = new ThemeDefinition("children", childrenWords,
                new TermDefinition(Cf.map(Language.RUSSIAN, russianTD,
                        Language.TURKISH, turkishTD,
                        Language.ENGLISH, englishTD,
                        Language.UKRAINIAN, ukranianTD)), true, Option.of(false), Option.of(true), Option.of(false), Option.empty());
themeDefinitionRegistry.put(childrenTheme);

russianTD = new TermLanguageDefinition("еда", "еды", "о", "еде", "едой", "еду", "к еде", Option.empty());
turkishTD = new TermLanguageDefinition("yiyecek", "yiyeceğin", "", "yiyeceği", "yiyeceğe", "yiyecekte", "yiyecekten", Option.empty());
englishTD = new TermLanguageDefinition("food", "of food", "of", "food", "food", "food", "to food", Option.empty());
ukranianTD = new TermLanguageDefinition("їжа", "їжі", "про", "їжу", "їжею", "їжу", "до їжі", Option.empty());
var foodWords = Cf.list(new WordMatch("еда", 5063), new WordMatch("food", 5336));
var foodTheme = new ThemeDefinition("food", foodWords,
                new TermDefinition(Cf.map(Language.RUSSIAN, russianTD,
                        Language.TURKISH, turkishTD,
                        Language.ENGLISH, englishTD,
                        Language.UKRAINIAN, ukranianTD)), true, Option.of(false), Option.of(true), Option.of(false), Option.empty());
themeDefinitionRegistry.put(foodTheme);

russianTD = new TermLanguageDefinition("лес", "леса", "о", "лесе", "лесом", "лес", "в лес", Option.empty());
turkishTD = new TermLanguageDefinition("orman", "ormanın", "", "ormanı", "ormana", "ormanda", "ormandan", Option.empty());
englishTD = new TermLanguageDefinition("forests", "of forests", "of", "forests", "forests", "forests", "to forests", Option.empty());
ukranianTD = new TermLanguageDefinition("ліс", "лісу", "про", "ліс", "лісом", "ліс", "у ліс", Option.empty());
var forestWords = Cf.list(new WordMatch("лес", 6199), new WordMatch("forest", 6783));
var forestTheme = new ThemeDefinition("forest", forestWords,
                new TermDefinition(Cf.map(Language.RUSSIAN, russianTD,
                        Language.TURKISH, turkishTD,
                        Language.ENGLISH, englishTD,
                        Language.UKRAINIAN, ukranianTD)), true, Option.of(false), Option.of(false), Option.of(false), Option.empty());
themeDefinitionRegistry.put(forestTheme);

russianTD = new TermLanguageDefinition("парк", "парка", "о", "парке", "парком", "парк", "в парк", Option.empty());
turkishTD = new TermLanguageDefinition("park", "parkın", "", "parkı", "parka", "parkta", "parktan", Option.empty());
englishTD = new TermLanguageDefinition("parks", "of parks", "of", "parks", "parks", "parks", "to parks", Option.empty());
ukranianTD = new TermLanguageDefinition("парк", "парку", "про", "парк", "парком", "парк", "у парк", Option.empty());
var parkWords = Cf.list(new WordMatch("парк", 5880), new WordMatch("park", 5903));
var parkTheme = new ThemeDefinition("park", parkWords,
                new TermDefinition(Cf.map(Language.RUSSIAN, russianTD,
                        Language.TURKISH, turkishTD,
                        Language.ENGLISH, englishTD,
                        Language.UKRAINIAN, ukranianTD)), true, Option.of(false), Option.of(false), Option.of(false), Option.empty());
themeDefinitionRegistry.put(parkTheme);

russianTD = new TermLanguageDefinition("лица", "лиц", "о", "лицах", "портретами", "портреты", "к портретам", Option.empty());
turkishTD = new TermLanguageDefinition("yüzler", "", "", "", "", "", "", Option.empty());
englishTD = new TermLanguageDefinition("faces", "", "", "", "", "", "", Option.empty());
ukranianTD = new TermLanguageDefinition("обличчя", "", "", "", "", "", "", Option.empty());
var portraitsWords = Cf.list(new WordMatch("лица", 4289), new WordMatch("портреты", 4222));
var portraitsTheme = new ThemeDefinition("portraits", portraitsWords,
                new TermDefinition(Cf.map(Language.RUSSIAN, russianTD,
                        Language.TURKISH, turkishTD,
                        Language.ENGLISH, englishTD,
                        Language.UKRAINIAN, ukranianTD)), true, Option.of(false), Option.of(true), Option.of(false), Option.of(1.0));
themeDefinitionRegistry.put(portraitsTheme);

