#!/usr/bin/env python
# -*- coding: utf-8 -*-


from common import component_packages
from start_sandbox_build import submit_sandbox_build
from package.build_component import debian_components

import sys
import os

from optparse import OptionParser, Option
import re

ARCADIA_BASE_URI = "svn+ssh://arcadia.yandex.ru/arc"
ARCADIA_TRUNK_URI = ARCADIA_BASE_URI + "/trunk"
DISK_BRANCHES_URI = ARCADIA_BASE_URI + "/branches/disk"

usage = "usage: %prog -h"

option_list = (
    Option(
        '-c', '--component',
        action='store',
        dest='component',
        type='string',
        default=None,
        help='Component name'
    ),
    Option(
        '-r', '--revision',
        action='store',
        dest='revision',
        type='string',
        default=None,
        help='Source revision to make branch'
    ),
    Option(
        '-t', '--deploy-testing',
        action='store_true',
        dest='deploy_testing',
        default=False,
        help='Deploy to testing after build'
    ),
    Option(
        '-p', '--deploy-prestable',
        action='store_true',
        dest='deploy_prestable',
        default=False,
        help='Deploy to prestable after build'
    ),
    Option(
        '--dry-run',
        action='store_true',
        dest='dry_run',
        default=False,
        help="run without commit",
    ),
)

parser = OptionParser(usage, option_list=option_list)
(options, args) = parser.parse_args()


def get_current_version(dirname):
    line = open(dirname + "debian/changelog").readline()
    match = re.search("^.*\(([^\.]*\.[^\.]*)..*\).*$", line)
    if not match:
        print "Can't find current version in changelog"
        sys.exit(1)
    return match.group(1)


def get_next_version(version):
    a, b = version.split(".")
    return a + "." + str(int(b) + 1)


def checked_exec(command):
    if options.dry_run:
        print "Dry-run!", command
    else:
        print command
        if os.system(command):
            sys.exit(1)


if __name__ == "__main__":
    os.chdir(os.path.abspath(os.path.join(os.path.abspath(sys.argv[0]), os.pardir, os.pardir)))

    # if os.popen("$YANDEX_BUILD/vcs/utils.sh is-uncommitted").readline().strip() == "true":
    #     print "repo already have uncommitted changes"
    #     sys.exit(1)

    current_path = os.path.dirname(sys.argv[0])
    root_path = os.path.normpath(current_path + '/../../')

    def svn(params, checked=True):
        cmd = current_path + '/ya svn ' + params
        if checked:
            checked_exec(cmd)
            return 0
        else:
            return os.system(cmd)

    def switch_branch(branch_uri, version):
        svn('switch ' + branch_uri + '/arcadia/ ' + root_path)
        checked_exec(current_path + '/set_changelog_version.sh ' + version)
        svn('commit ' + current_path + '/../debian/changelog -m "ver++ (current version ' + version + ') SKIP_CHECK"')

    if svn('up ' + root_path, checked=False):
        print 'Failed to pull changes'
        sys.exit(1)

    branch = os.popen(current_path + '/get_current_branch.sh').readline().strip()

    if branch != "master":
        print "Not on master branch"
        sys.exit(1)

    component = options.component
    if component:
        if component not in component_packages and not os.path.exists(component):
            print 'Unknown component', component
            sys.exit(1)

        print 'making release branch for component', component
        version = get_current_version(current_path + "/../")
        version_in_branch = version + ".1"
        branch_name = "release_" + component + "_" + version
        new_version_in_master = get_next_version(version) + ".0.1"

        print ''
        print 'Current version', version
        print 'New version in master', new_version_in_master
        print ''
        print 'Branch name', branch_name
        print 'Version in branch', version_in_branch
        print ''

        new_branch_uri = DISK_BRANCHES_URI + '/' + branch_name
        svn('cp '
            + ('-r' + options.revision + ' ' if options.revision else "")
            + ARCADIA_TRUNK_URI + ' '
            + new_branch_uri
            + ' -m "create release branch ' + branch_name + '"')

        switch_branch(new_branch_uri, version_in_branch)

        print ''

        switch_branch(ARCADIA_TRUNK_URI, new_version_in_master)

        print ''

        svn('up ' + root_path)

        if options.dry_run:
            print "Dry-run!", "submit_sandbox_build(" \
                              + branch_name \
                              + ', tar, deploy_testing=' + str(options.deploy_testing) \
                              + ', deploy_prestable=' + str(options.deploy_prestable) + ')'
        else:
            submit_sandbox_build(branch_name, 'tar', deploy_testing=options.deploy_testing, deploy_prestable=options.deploy_prestable)

        if component in debian_components:
            if options.dry_run:
                print "Dry-run!", "submit_sandbox_build(" \
                                  + branch_name \
                                  + ', debian)'
            else:
                submit_sandbox_build(branch_name, 'debian')

    else:
        parser.print_usage()
